/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.handler;

import ch.rasc.wampspring.message.WampMessage;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WampMessageSender {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, WebSocketSession> sessions = new ConcurrentHashMap<String, WebSocketSession>();
    private final Executor outboundExecutor;
    private final JsonFactory jsonFactory;

    public WampMessageSender(Executor outboundExecutor, JsonFactory jsonFactory) {
        this.outboundExecutor = outboundExecutor;
        this.jsonFactory = jsonFactory;
    }

    void put(String sessionId, WebSocketSession session) {
        this.sessions.put(sessionId, session);
    }

    void remove(String sessionId) {
        this.sessions.remove(sessionId);
    }

    void sendMessageToClient(String sessionId, WampMessage message) {
        this.sendMessageToClient(Collections.singleton(sessionId), message);
    }

    void sendMessageToClient(final Set<String> sessionIds, WampMessage message) {
        if (sessionIds == null || sessionIds.isEmpty()) {
            return;
        }
        String json = null;
        try {
            json = message.toJson(this.jsonFactory);
        }
        catch (IOException e) {
            this.logger.error((Object)("Conversion of message " + message + " into json failed"), (Throwable)e);
        }
        if (this.outboundExecutor == null) {
            for (String sessionId : sessionIds) {
                this.sendMessage(sessionId, json);
            }
        } else {
            final String textMessage = json;
            this.outboundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (String sessionId : sessionIds) {
                        WampMessageSender.this.sendMessage(sessionId, textMessage);
                    }
                }
            });
        }
    }

    private void sendMessage(String sessionId, String json) {
        WebSocketSession session = this.sessions.get(sessionId);
        if (session == null) {
            this.logger.error((Object)("Session not found for sessionId " + sessionId));
            return;
        }
        try {
            if (session.isOpen()) {
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            } else {
                this.sessions.remove(session.getId());
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("Sending of message '" + json + "' failed"), (Throwable)e);
        }
    }
}

