/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.support;

import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.support.HandlerMethodArgumentResolver;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;

public class HandlerMethodArgumentResolverComposite
implements HandlerMethodArgumentResolver {
    private final List<HandlerMethodArgumentResolver> argumentResolvers = new LinkedList<HandlerMethodArgumentResolver>();
    private final Map<MethodParameter, HandlerMethodArgumentResolver> argumentResolverCache = new ConcurrentHashMap<MethodParameter, HandlerMethodArgumentResolver>(256);

    public List<HandlerMethodArgumentResolver> getResolvers() {
        return Collections.unmodifiableList(this.argumentResolvers);
    }

    public void clear() {
        this.argumentResolvers.clear();
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.getArgumentResolver(parameter) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, WampMessage message) throws Exception {
        HandlerMethodArgumentResolver resolver = this.getArgumentResolver(parameter);
        Assert.notNull((Object)resolver, (String)("Unknown parameter type [" + parameter.getParameterType().getName() + "]"));
        return resolver.resolveArgument(parameter, message);
    }

    private HandlerMethodArgumentResolver getArgumentResolver(MethodParameter parameter) {
        HandlerMethodArgumentResolver result = this.argumentResolverCache.get(parameter);
        if (result == null) {
            for (HandlerMethodArgumentResolver resolver : this.argumentResolvers) {
                if (!resolver.supportsParameter(parameter)) continue;
                result = resolver;
                this.argumentResolverCache.put(parameter, result);
                break;
            }
        }
        return result;
    }

    public HandlerMethodArgumentResolverComposite addResolver(HandlerMethodArgumentResolver argumentResolver) {
        this.argumentResolvers.add(argumentResolver);
        return this;
    }

    public HandlerMethodArgumentResolverComposite addResolvers(List<? extends HandlerMethodArgumentResolver> argResolvers) {
        if (argResolvers != null) {
            for (HandlerMethodArgumentResolver handlerMethodArgumentResolver : argResolvers) {
                this.argumentResolvers.add(handlerMethodArgumentResolver);
            }
        }
        return this;
    }
}

