/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.support;

import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.support.HandlerMethodArgumentResolverComposite;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;

public class InvocableHandlerMethod
extends HandlerMethod {
    private HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final ConversionService conversionService;
    private final ObjectMapper objectMapper;

    public InvocableHandlerMethod(HandlerMethod handlerMethod, ObjectMapper objectMapper, ConversionService conversionService) {
        super(handlerMethod);
        this.objectMapper = objectMapper;
        this.conversionService = conversionService;
    }

    public void setMessageMethodArgumentResolvers(HandlerMethodArgumentResolverComposite argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public final Object invoke(WampMessage message, Object ... providedArgs) throws Exception {
        Object[] args = this.getMethodArgumentValues(message, providedArgs);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking [" + this.getBeanType().getSimpleName() + "." + this.getMethod().getName() + "] method with arguments " + Arrays.asList(args)));
        }
        Object returnValue = this.invoke(args);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Method [" + this.getMethod().getName() + "] returned [" + returnValue + "]"));
        }
        return returnValue;
    }

    private Object[] getMethodArgumentValues(WampMessage message, Object ... providedArgs) throws Exception {
        MethodParameter[] parameters = this.getMethodParameters();
        Object[] args = new Object[parameters.length];
        int argIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.getBean().getClass());
            if (this.argumentResolvers.supportsParameter(parameter)) {
                try {
                    args[i] = this.argumentResolvers.resolveArgument(parameter, message);
                    continue;
                }
                catch (Exception ex) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.getArgumentResolutionErrorMessage("Error resolving argument", i), (Throwable)ex);
                    }
                    throw ex;
                }
            }
            if (providedArgs != null) {
                args[i] = this.resolveProvidedArgument(parameter, providedArgs[argIndex]);
                if (args[i] != null) {
                    ++argIndex;
                    continue;
                }
            }
            if (args[i] != null) continue;
            String msg = this.getArgumentResolutionErrorMessage("No suitable resolver for argument", i);
            throw new IllegalStateException(msg);
        }
        return args;
    }

    private String getArgumentResolutionErrorMessage(String message, int index) {
        MethodParameter param = this.getMethodParameters()[index];
        return this.getDetailedErrorMessage(message + " [" + index + "] [type=" + param.getParameterType().getName() + "]");
    }

    String getDetailedErrorMessage(String message) {
        return message + "\n" + "HandlerMethod details: \n" + "Bean [" + this.getBeanType().getName() + "]\n" + "Method [" + this.getBridgedMethod().toGenericString() + "]\n";
    }

    private Object resolveProvidedArgument(MethodParameter parameter, Object argument) {
        if (argument == null) {
            return null;
        }
        Class<?> sourceClass = argument.getClass();
        Class targetClass = parameter.getParameterType();
        TypeDescriptor td = new TypeDescriptor(parameter);
        if (targetClass.isAssignableFrom(sourceClass)) {
            return this.convertListElements(td, argument);
        }
        if (this.conversionService.canConvert(sourceClass, targetClass)) {
            try {
                return this.convertListElements(td, this.conversionService.convert(argument, targetClass));
            }
            catch (Exception e) {
                TypeFactory typeFactory = this.objectMapper.getTypeFactory();
                if (td.isCollection()) {
                    CollectionType type = CollectionType.construct((Class)td.getType(), (JavaType)typeFactory.constructType((Type)td.getElementTypeDescriptor().getType()));
                    return this.objectMapper.convertValue(argument, (JavaType)type);
                }
                if (td.isArray()) {
                    ArrayType type = typeFactory.constructArrayType(td.getElementTypeDescriptor().getType());
                    return this.objectMapper.convertValue(argument, (JavaType)type);
                }
                throw e;
            }
        }
        return this.objectMapper.convertValue(argument, targetClass);
    }

    private Object convertListElements(TypeDescriptor td, Object convertedValue) {
        if (List.class.isAssignableFrom(convertedValue.getClass()) && td.isCollection() && td.getElementTypeDescriptor() != null) {
            Class elementType = td.getElementTypeDescriptor().getType();
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : (List)convertedValue) {
                Object convertedObject = this.objectMapper.convertValue(record, elementType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return convertedValue;
    }

    Object invoke(Object ... args) throws Exception {
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        try {
            return this.getBridgedMethod().invoke(this.getBean(), args);
        }
        catch (IllegalArgumentException e) {
            String msg = this.getInvocationErrorMessage(e.getMessage(), args);
            throw new IllegalArgumentException(msg, e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            String msg = this.getInvocationErrorMessage("Failed to invoke controller method", args);
            throw new IllegalStateException(msg, targetException);
        }
    }

    private String getInvocationErrorMessage(String message, Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(this.getDetailedErrorMessage(message));
        sb.append("Resolved arguments: \n");
        for (int i = 0; i < resolvedArgs.length; ++i) {
            sb.append("[").append(i).append("] ");
            if (resolvedArgs[i] == null) {
                sb.append("[null] \n");
                continue;
            }
            sb.append("[type=").append(resolvedArgs[i].getClass().getName()).append("] ");
            sb.append("[value=").append(resolvedArgs[i]).append("]\n");
        }
        return sb.toString();
    }
}

