/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.handler;

import ch.rasc.wampspring.handler.WampMessageSender;
import ch.rasc.wampspring.message.EventMessage;
import ch.rasc.wampspring.message.PublishMessage;
import ch.rasc.wampspring.message.SubscribeMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageHeader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PubSubHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, Set<String>> topicSessionIds = new ConcurrentHashMap<String, Set<String>>();
    private final Object monitor = new Object();
    private final WampMessageSender wampMessageSender;

    public PubSubHandler(WampMessageSender wampMessageSender) {
        this.wampMessageSender = wampMessageSender;
    }

    void handleMessage(WampMessage message) {
        switch (message.getType()) {
            case EVENT: {
                this.sendToAll((EventMessage)message);
                break;
            }
            case PUBLISH: {
                this.handlePublishMessage((PublishMessage)message);
                break;
            }
            case SUBSCRIBE: {
                this.handleSubscribeMessage((SubscribeMessage)message);
                break;
            }
            case UNSUBSCRIBE: {
                this.handleUnsubscribeMessage((UnsubscribeMessage)message);
                break;
            }
        }
    }

    public void sendToAll(EventMessage eventMessage) {
        Set<String> sessions = this.topicSessionIds.get(eventMessage.getTopicURI());
        this.wampMessageSender.sendMessageToClient(sessions, (WampMessage)eventMessage);
    }

    public void sendToAllExcept(EventMessage eventMessage, Set<String> excludeSessionIds) {
        Set<String> subscriptionSessions = this.topicSessionIds.get(eventMessage.getTopicURI());
        if (subscriptionSessions != null) {
            HashSet<String> eligibleSessions = new HashSet<String>();
            for (String sessionId : subscriptionSessions) {
                if (excludeSessionIds.contains(sessionId)) continue;
                eligibleSessions.add(sessionId);
            }
            this.wampMessageSender.sendMessageToClient(eligibleSessions, (WampMessage)eventMessage);
        }
    }

    public void sendTo(EventMessage eventMessage, Set<String> eligibleSessionIds) {
        Set<String> subscriptionSessions = this.topicSessionIds.get(eventMessage.getTopicURI());
        if (subscriptionSessions != null) {
            HashSet<String> eligibleSessions = new HashSet<String>();
            for (String sessionId : subscriptionSessions) {
                if (!eligibleSessionIds.contains(sessionId)) continue;
                eligibleSessions.add(sessionId);
            }
            this.wampMessageSender.sendMessageToClient(eligibleSessions, (WampMessage)eventMessage);
        }
    }

    private void handlePublishMessage(PublishMessage publishMessage) {
        Set<String> subscriptionSessions = this.topicSessionIds.get(publishMessage.getTopicURI());
        if (subscriptionSessions != null) {
            String mySessionId = (String)publishMessage.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
            HashSet<String> eligibleSessions = new HashSet<String>();
            for (String sessionId : subscriptionSessions) {
                if (!PubSubHandler.isSessionEligible(publishMessage, mySessionId, sessionId)) continue;
                eligibleSessions.add(sessionId);
            }
            if (!eligibleSessions.isEmpty()) {
                EventMessage eventMessage = new EventMessage(publishMessage.getTopicURI(), publishMessage.getEvent());
                this.wampMessageSender.sendMessageToClient(eligibleSessions, (WampMessage)eventMessage);
            }
        }
    }

    private static boolean isSessionEligible(PublishMessage publishMessage, String mySessionId, String otherSessionId) {
        if (publishMessage.getExcludeMe() != null && publishMessage.getExcludeMe().booleanValue() && mySessionId.equals(otherSessionId)) {
            return false;
        }
        if (publishMessage.getEligible() != null && !publishMessage.getEligible().contains(otherSessionId)) {
            return false;
        }
        return publishMessage.getExclude() == null || !publishMessage.getExclude().contains(otherSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubscribeMessage(SubscribeMessage message) {
        String sessionId = (String)message.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
        String topicURI = message.getTopicURI();
        Object object = this.monitor;
        synchronized (object) {
            Set<String> sessions = this.topicSessionIds.get(topicURI);
            if (sessions == null) {
                sessions = new CopyOnWriteArraySet<String>();
                this.topicSessionIds.put(topicURI, sessions);
            }
            sessions.add(sessionId);
        }
    }

    private void handleUnsubscribeMessage(UnsubscribeMessage message) {
        String sessionId = (String)message.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
        String topicURI = message.getTopicURI();
        if (topicURI == null) {
            this.logger.error((Object)("Ignoring subscription. No topicURI in message: " + message));
            return;
        }
        this.removeSession(sessionId, topicURI);
    }

    List<String> unregisterSessionFromAllSubscriptions(String sessionId) {
        ArrayList<String> topicURIs = new ArrayList<String>();
        for (String topicURI : this.topicSessionIds.keySet()) {
            if (!this.removeSession(sessionId, topicURI)) continue;
            topicURIs.add(topicURI);
        }
        return topicURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSession(String sessionId, String topicURI) {
        Object object = this.monitor;
        synchronized (object) {
            Set<String> sessions = this.topicSessionIds.get(topicURI);
            if (sessions != null) {
                boolean removed = sessions.remove(sessionId);
                if (removed && sessions.isEmpty()) {
                    this.topicSessionIds.remove(topicURI);
                }
                return removed;
            }
            return false;
        }
    }
}

