/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.handler;

import ch.rasc.wampspring.handler.AnnotationMethodHandler;
import ch.rasc.wampspring.handler.PubSubHandler;
import ch.rasc.wampspring.handler.WampMessageSender;
import ch.rasc.wampspring.handler.WampSession;
import ch.rasc.wampspring.message.CallMessage;
import ch.rasc.wampspring.message.PrefixMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageHeader;
import ch.rasc.wampspring.message.WelcomeMessage;
import com.fasterxml.jackson.core.JsonFactory;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WampWebsocketHandler
implements WebSocketHandler,
SubProtocolCapable {
    private static final List<String> SUPPORTED_SUB_PROTOCOL_LIST = Collections.singletonList("wamp");
    private static final String SERVER_IDENTIFIER = "wampspring/1.0";
    private final WampMessageSender wampMessageSender;
    private final AnnotationMethodHandler annotationMethodHandler;
    private final PubSubHandler pubSubHandler;
    private final JsonFactory jsonFactory;
    private final ConcurrentHashMap<String, WampSession> webSocketSessionIdToWampSession = new ConcurrentHashMap();

    public WampWebsocketHandler(AnnotationMethodHandler annotationMethodHandler, PubSubHandler pubSubHandler, WampMessageSender wampMessageSender, JsonFactory jsonFactory) {
        this.annotationMethodHandler = annotationMethodHandler;
        this.pubSubHandler = pubSubHandler;
        this.wampMessageSender = wampMessageSender;
        this.jsonFactory = jsonFactory;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.wampMessageSender.put(session.getId(), session);
        WelcomeMessage welcomeMessage = new WelcomeMessage(session.getId(), SERVER_IDENTIFIER);
        session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)welcomeMessage.toJson(this.jsonFactory)));
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> webSocketMessage) throws Exception {
        Assert.isInstanceOf(TextMessage.class, webSocketMessage);
        WampMessage message = (WampMessage)WampMessage.fromJson(this.jsonFactory, (String)((TextMessage)webSocketMessage).getPayload());
        message.addHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, session.getId());
        message.addHeader(WampMessageHeader.PRINCIPAL, session.getPrincipal());
        WampSession wampSession = this.getOrCreateWampSession(session);
        message.addHeader(WampMessageHeader.WAMP_SESSION, wampSession);
        if (!wampSession.isAuthenticated() && message instanceof CallMessage && this.annotationMethodHandler.isAuthenticationRequired((CallMessage)message)) {
            throw new SecurityException("Not authenticated");
        }
        if (message instanceof PrefixMessage) {
            PrefixMessage prefixMessage = (PrefixMessage)message;
            wampSession.addPrefix(prefixMessage.getPrefix(), prefixMessage.getUri());
        } else {
            this.pubSubHandler.handleMessage(message);
            this.annotationMethodHandler.handleMessage(message);
        }
    }

    WampSession getOrCreateWampSession(WebSocketSession session) {
        WampSession wampSession = this.webSocketSessionIdToWampSession.get(session.getId());
        if (wampSession == null) {
            wampSession = new WampSession();
            WampSession sessionFromAnotherThread = this.webSocketSessionIdToWampSession.putIfAbsent(session.getId(), wampSession);
            if (sessionFromAnotherThread != null) {
                wampSession = sessionFromAnotherThread;
            }
        }
        return wampSession;
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        String sessionId = session.getId();
        this.webSocketSessionIdToWampSession.remove(sessionId);
        this.wampMessageSender.remove(sessionId);
        List<String> topicURIs = this.pubSubHandler.unregisterSessionFromAllSubscriptions(sessionId);
        for (String topicURI : topicURIs) {
            UnsubscribeMessage unsubscribeMessage = new UnsubscribeMessage(topicURI);
            unsubscribeMessage.addHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, sessionId);
            unsubscribeMessage.addHeader(WampMessageHeader.WAMP_SESSION, this.getOrCreateWampSession(session));
            this.annotationMethodHandler.handleMessage(unsubscribeMessage);
        }
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public List<String> getSubProtocols() {
        return SUPPORTED_SUB_PROTOCOL_LIST;
    }
}

