/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.message;

import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Set;

public class PublishMessage
extends WampMessage {
    private final String topicURI;
    private final Object event;
    private final Boolean excludeMe;
    private final Set<String> exclude;
    private final Set<String> eligible;

    public PublishMessage(String topicURI, Object event) {
        this(topicURI, event, null, null, null);
    }

    public PublishMessage(String topicURI, Object event, Boolean excludeMe) {
        this(topicURI, event, excludeMe, null, null);
    }

    public PublishMessage(String topicURI, Object event, Set<String> exclude) {
        this(topicURI, event, null, exclude, null);
    }

    public PublishMessage(String topicURI, Object event, Set<String> exclude, Set<String> eligible) {
        this(topicURI, event, null, exclude, eligible);
    }

    private PublishMessage(String topicURI, Object event, Boolean excludeMe, Set<String> exclude, Set<String> eligible) {
        super(WampMessageType.PUBLISH);
        this.topicURI = topicURI;
        this.event = event;
        this.excludeMe = excludeMe;
        this.exclude = exclude;
        this.eligible = eligible;
    }

    public PublishMessage(JsonParser jp) throws IOException {
        super(WampMessageType.PUBLISH);
        if (jp.nextToken() != JsonToken.VALUE_STRING) {
            throw new IOException();
        }
        this.topicURI = jp.getValueAsString();
        jp.nextToken();
        this.event = jp.readValueAs(Object.class);
        if (jp.nextToken() != JsonToken.END_ARRAY) {
            if (jp.getCurrentToken() == JsonToken.VALUE_TRUE || jp.getCurrentToken() == JsonToken.VALUE_FALSE) {
                this.excludeMe = jp.getValueAsBoolean();
                this.exclude = null;
                this.eligible = null;
                if (jp.nextToken() != JsonToken.END_ARRAY) {
                    throw new IOException();
                }
            } else {
                this.excludeMe = null;
                TypeReference<Set<String>> typRef = new TypeReference<Set<String>>(){};
                if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
                    throw new IOException();
                }
                this.exclude = (Set)jp.readValueAs((TypeReference)typRef);
                this.eligible = jp.nextToken() == JsonToken.START_ARRAY ? (Set)jp.readValueAs((TypeReference)typRef) : null;
            }
        } else {
            this.excludeMe = null;
            this.exclude = null;
            this.eligible = null;
        }
    }

    public String getTopicURI() {
        return this.topicURI;
    }

    public Object getEvent() {
        return this.event;
    }

    public Boolean getExcludeMe() {
        return this.excludeMe;
    }

    public Set<String> getExclude() {
        return this.exclude;
    }

    public Set<String> getEligible() {
        return this.eligible;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String toJson(JsonFactory jsonFactory) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "PublishMessage [topicURI=" + this.topicURI + ", event=" + this.event + ", excludeMe=" + this.excludeMe + ", exclude=" + this.exclude + ", eligible=" + this.eligible + "]";
    }
}

