/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.message;

import ch.rasc.wampspring.handler.WampSession;
import ch.rasc.wampspring.message.CallErrorMessage;
import ch.rasc.wampspring.message.CallMessage;
import ch.rasc.wampspring.message.CallResultMessage;
import ch.rasc.wampspring.message.EventMessage;
import ch.rasc.wampspring.message.PrefixMessage;
import ch.rasc.wampspring.message.PublishMessage;
import ch.rasc.wampspring.message.SubscribeMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessageHeader;
import ch.rasc.wampspring.message.WampMessageType;
import ch.rasc.wampspring.message.WelcomeMessage;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.EnumMap;

public abstract class WampMessage {
    private final WampMessageType type;
    private EnumMap<WampMessageHeader, Object> headers;

    WampMessage(WampMessageType type) {
        this.type = type;
    }

    int getTypeId() {
        return this.type.getTypeId();
    }

    public WampMessageType getType() {
        return this.type;
    }

    public void addHeader(WampMessageHeader header, Object value) {
        if (this.headers == null) {
            this.headers = new EnumMap(WampMessageHeader.class);
        }
        this.headers.put(header, value);
    }

    public <T> T getHeader(WampMessageHeader header) {
        if (this.headers == null) {
            return null;
        }
        return (T)this.headers.get((Object)header);
    }

    public String getWebSocketSessionId() {
        return (String)this.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
    }

    public WampSession getWampSession() {
        return (WampSession)this.getHeader(WampMessageHeader.WAMP_SESSION);
    }

    public abstract String toJson(JsonFactory var1) throws IOException;

    public static <T> T fromJson(JsonFactory jsonFactory, String json) throws IOException {
        try (JsonParser jp = jsonFactory.createParser(json);){
            if (jp.nextToken() != JsonToken.START_ARRAY) {
                throw new IOException("Not a JSON array");
            }
            if (jp.nextToken() != JsonToken.VALUE_NUMBER_INT) {
                throw new IOException("Wrong message format");
            }
            WampMessageType messageType = WampMessageType.fromTypeId(jp.getValueAsInt());
            switch (messageType) {
                case WELCOME: {
                    WelcomeMessage welcomeMessage = new WelcomeMessage(jp);
                    return (T)welcomeMessage;
                }
                case PREFIX: {
                    PrefixMessage prefixMessage = new PrefixMessage(jp);
                    return (T)prefixMessage;
                }
                case CALL: {
                    CallMessage callMessage = new CallMessage(jp);
                    return (T)callMessage;
                }
                case CALLRESULT: {
                    CallResultMessage callResultMessage = new CallResultMessage(jp);
                    return (T)callResultMessage;
                }
                case CALLERROR: {
                    CallErrorMessage callErrorMessage = new CallErrorMessage(jp);
                    return (T)callErrorMessage;
                }
                case SUBSCRIBE: {
                    SubscribeMessage subscribeMessage = new SubscribeMessage(jp);
                    return (T)subscribeMessage;
                }
                case UNSUBSCRIBE: {
                    UnsubscribeMessage unsubscribeMessage = new UnsubscribeMessage(jp);
                    return (T)unsubscribeMessage;
                }
                case PUBLISH: {
                    PublishMessage publishMessage = new PublishMessage(jp);
                    return (T)publishMessage;
                }
                case EVENT: {
                    EventMessage eventMessage = new EventMessage(jp);
                    return (T)eventMessage;
                }
            }
            T t = null;
            return t;
        }
    }
}

