/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import ch.rasc.wampspring.EventMessenger;
import ch.rasc.wampspring.broker.DefaultSubscriptionRegistry;
import ch.rasc.wampspring.broker.SimpleBrokerMessageHandler;
import ch.rasc.wampspring.broker.SubscriptionRegistry;
import ch.rasc.wampspring.config.WampConfigurer;
import ch.rasc.wampspring.config.WampEndpointRegistry;
import ch.rasc.wampspring.config.WampMessageSelector;
import ch.rasc.wampspring.config.WampMessageSelectors;
import ch.rasc.wampspring.config.WampSession;
import ch.rasc.wampspring.config.WampSessionScope;
import ch.rasc.wampspring.config.WebMvcWampEndpointRegistry;
import ch.rasc.wampspring.config.WebSocketTransportRegistration;
import ch.rasc.wampspring.cra.AuthenticationHandler;
import ch.rasc.wampspring.cra.AuthenticationSecretProvider;
import ch.rasc.wampspring.cra.DefaultAuthenticationHandler;
import ch.rasc.wampspring.method.MethodParameterConverter;
import ch.rasc.wampspring.method.WampAnnotationMethodMessageHandler;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
public class DefaultWampConfiguration {
    private final List<WampConfigurer> configurers = new ArrayList<WampConfigurer>();
    private ObjectMapper objectMapper = null;
    protected ObjectMapper internalObjectMapper = null;
    protected PathMatcher internalPathMatcher = null;
    protected ConversionService internalConversionService = null;
    private WebSocketTransportRegistration transportRegistration;

    @Autowired(required=false)
    public void setConfigurers(List<WampConfigurer> configurers) {
        if (!CollectionUtils.isEmpty(configurers)) {
            this.configurers.addAll(configurers);
        }
    }

    @Autowired(required=false)
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected void registerWampEndpoints(WampEndpointRegistry registry) {
        if (this.configurers.isEmpty()) {
            registry.addEndpoint("/wamp");
        } else {
            for (WampConfigurer wc : this.configurers) {
                wc.registerWampEndpoints(registry);
            }
        }
    }

    @Bean
    public SubscribableChannel clientInboundChannel() {
        ExecutorSubscribableChannel executorSubscribableChannel = new ExecutorSubscribableChannel(this.clientInboundChannelExecutor());
        this.configureClientInboundChannel((AbstractMessageChannel)executorSubscribableChannel);
        return executorSubscribableChannel;
    }

    protected void configureClientInboundChannel(AbstractMessageChannel channel) {
        for (WampConfigurer wc : this.configurers) {
            wc.configureClientInboundChannel(channel);
        }
    }

    @Bean
    public Executor clientInboundChannelExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("wampClientInboundChannel-");
        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 2);
        executor.setMaxPoolSize(Integer.MAX_VALUE);
        executor.setKeepAliveSeconds(60);
        executor.setQueueCapacity(Integer.MAX_VALUE);
        executor.setAllowCoreThreadTimeOut(true);
        return executor;
    }

    @Bean
    public SubscribableChannel clientOutboundChannel() {
        return new ExecutorSubscribableChannel(this.clientOutboundChannelExecutor());
    }

    @Bean
    public Executor clientOutboundChannelExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("wampClientOutboundChannel-");
        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 2);
        executor.setMaxPoolSize(Integer.MAX_VALUE);
        executor.setKeepAliveSeconds(60);
        executor.setQueueCapacity(Integer.MAX_VALUE);
        executor.setAllowCoreThreadTimeOut(true);
        return executor;
    }

    @Bean
    public SubscribableChannel brokerChannel() {
        return new ExecutorSubscribableChannel(this.brokerChannelExecutor());
    }

    public Executor brokerChannelExecutor() {
        return null;
    }

    @Bean
    public MessageHandler brokerMessageHandler() {
        SimpleBrokerMessageHandler messageHandler = new SimpleBrokerMessageHandler(this.clientInboundChannel(), (MessageChannel)this.clientOutboundChannel(), this.brokerChannel(), this.subscriptionRegistry(), this.brokerMessageHandlerMessageSelector());
        messageHandler.setAuthenticationRequiredGlobal(this.authenticationRequired());
        return messageHandler;
    }

    @Bean
    public SubscriptionRegistry subscriptionRegistry() {
        return new DefaultSubscriptionRegistry(this.pathMatcher());
    }

    protected WampMessageSelector brokerMessageHandlerMessageSelector() {
        return WampMessageSelectors.ACCEPT_ALL;
    }

    @Bean
    public MessageHandler annotationMethodMessageHandler(ConfigurableApplicationContext configurableApplicationContext) {
        AuthenticationHandler authenticationHandler = this.authenticationHandler();
        if (authenticationHandler != null) {
            configurableApplicationContext.getBeanFactory().registerSingleton("authenticationHandler", (Object)authenticationHandler);
        }
        WampAnnotationMethodMessageHandler messageHandler = new WampAnnotationMethodMessageHandler(this.clientInboundChannel(), (MessageChannel)this.clientOutboundChannel(), this.eventMessenger(), this.conversionService(), this.methodParameterConverter(), this.pathMatcher(), this.methodMessageHandlerMessageSelector());
        messageHandler.setAuthenticationRequiredGlobal(this.authenticationRequired());
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
        this.addArgumentResolvers(argumentResolvers);
        messageHandler.setCustomArgumentResolvers(argumentResolvers);
        return messageHandler;
    }

    protected MethodParameterConverter methodParameterConverter() {
        return new MethodParameterConverter(this.lookupObjectMapper(), this.conversionService());
    }

    protected WampMessageSelector methodMessageHandlerMessageSelector() {
        return WampMessageSelectors.ACCEPT_ALL;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        for (WampConfigurer wc : this.configurers) {
            wc.addArgumentResolvers(argumentResolvers);
        }
    }

    @Bean
    public EventMessenger eventMessenger() {
        return new EventMessenger((MessageChannel)this.brokerChannel(), (MessageChannel)this.clientOutboundChannel());
    }

    protected PathMatcher pathMatcher() {
        if (this.internalPathMatcher == null) {
            this.internalPathMatcher = new AntPathMatcher();
        }
        return this.internalPathMatcher;
    }

    protected ObjectMapper objectMapper() {
        return null;
    }

    private ObjectMapper lookupObjectMapper() {
        if (this.internalObjectMapper == null) {
            this.internalObjectMapper = this.objectMapper();
        }
        if (this.internalObjectMapper == null) {
            this.internalObjectMapper = this.objectMapper;
        }
        if (this.internalObjectMapper == null) {
            this.internalObjectMapper = new ObjectMapper();
        }
        return this.internalObjectMapper;
    }

    public ConversionService conversionService() {
        if (this.internalConversionService == null) {
            this.internalConversionService = new DefaultFormattingConversionService();
        }
        return this.internalConversionService;
    }

    public AuthenticationSecretProvider authenticationSecretProvider() {
        return null;
    }

    public AuthenticationHandler authenticationHandler() {
        if (this.authenticationSecretProvider() != null) {
            return new DefaultAuthenticationHandler(this.authenticationSecretProvider());
        }
        return null;
    }

    public boolean authenticationRequired() {
        return false;
    }

    @Bean
    public HandlerMapping wampWebSocketHandlerMapping() {
        WebSocketHandler handler = this.subProtocolWebSocketHandler();
        handler = this.decorateWebSocketHandler(handler);
        WebMvcWampEndpointRegistry registry = new WebMvcWampEndpointRegistry(handler, this.getTransportRegistration(), (TaskScheduler)this.messageBrokerSockJsTaskScheduler(), (JsonFactory)new MappingJsonFactory(this.lookupObjectMapper()));
        ArrayList<HandshakeInterceptor> handshakeInterceptors = new ArrayList<HandshakeInterceptor>();
        this.addHandshakeInterceptors(handshakeInterceptors);
        registry.addHandshakeInterceptors(handshakeInterceptors);
        this.registerWampEndpoints(registry);
        return registry.getHandlerMapping();
    }

    @Bean
    public WebSocketHandler subProtocolWebSocketHandler() {
        return new SubProtocolWebSocketHandler((MessageChannel)this.clientInboundChannel(), this.clientOutboundChannel());
    }

    protected void addHandshakeInterceptors(List<HandshakeInterceptor> handshakeInterceptors) {
        for (WampConfigurer wc : this.configurers) {
            wc.addHandshakeInterceptors(handshakeInterceptors);
        }
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        WebSocketHandler decoratedHandler = handler;
        for (WebSocketHandlerDecoratorFactory factory : this.getTransportRegistration().getDecoratorFactories()) {
            decoratedHandler = factory.decorate(decoratedHandler);
        }
        return decoratedHandler;
    }

    protected final WebSocketTransportRegistration getTransportRegistration() {
        if (this.transportRegistration == null) {
            this.transportRegistration = new WebSocketTransportRegistration();
            this.configureWebSocketTransport(this.transportRegistration);
        }
        return this.transportRegistration;
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        for (WampConfigurer wc : this.configurers) {
            wc.configureWebSocketTransport(registration);
        }
    }

    @Bean
    public ThreadPoolTaskScheduler messageBrokerSockJsTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("WampSockJS-");
        scheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    @Bean
    public static CustomScopeConfigurer webSocketScopeConfigurer(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerResolvableDependency(WebSocketSession.class, (Object)new WampSessionScope.WebSocketSessionObjectFactory());
        beanFactory.registerResolvableDependency(WampSession.class, (Object)new WampSessionScope.WampSessionObjectFactory());
        CustomScopeConfigurer configurer = new CustomScopeConfigurer();
        configurer.addScope("wampsession", (Scope)new WampSessionScope());
        return configurer;
    }
}

