/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.cra;

import ch.rasc.wampspring.config.WampSession;
import ch.rasc.wampspring.cra.AuthenticationHandler;
import ch.rasc.wampspring.cra.AuthenticationSecretProvider;
import ch.rasc.wampspring.message.CallMessage;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultAuthenticationHandler
implements AuthenticationHandler {
    private final AuthenticationSecretProvider authenticationSecretProvider;

    public DefaultAuthenticationHandler(AuthenticationSecretProvider provider) {
        this.authenticationSecretProvider = provider;
    }

    @Override
    public Object handleAuthReq(String authKey, Map<String, Object> extra, CallMessage message) {
        WampSession wampSession = message.getWampSession();
        if (wampSession.isAuthRequested()) {
            throw new IllegalStateException("Already authenticated");
        }
        if (this.authenticationSecretProvider.getSecret(authKey) == null) {
            throw new IllegalStateException("Secret key does not exist");
        }
        try {
            String challenge = DefaultAuthenticationHandler.generateHMacSHA256(message.getWebSocketSessionId() + System.currentTimeMillis(), authKey);
            wampSession.setAuthKey(authKey);
            wampSession.setChallenge(challenge);
            return challenge;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("invalid key", e);
        }
    }

    @Override
    public Object handleAuth(String clientSignature, CallMessage message) {
        String correctSignature;
        WampSession wampSession = message.getWampSession();
        if (!wampSession.isAuthRequested()) {
            throw new IllegalStateException("No authentication previously requested");
        }
        try {
            String secret = this.authenticationSecretProvider.getSecret(wampSession.getAuthKey());
            if (!StringUtils.hasText((String)secret)) {
                throw new IllegalStateException("Secret does not exist");
            }
            correctSignature = DefaultAuthenticationHandler.generateHMacSHA256(secret, wampSession.getChallenge());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("invalid key", e);
        }
        if (clientSignature.equals(correctSignature)) {
            wampSession.setSignature(clientSignature);
            return null;
        }
        wampSession.setAuthKey(null);
        wampSession.setChallenge(null);
        wampSession.setSignature(null);
        throw new SecurityException("Signature for authentication request is invalid");
    }

    public static String generateHMacSHA256(String key, String data) throws InvalidKeyException, NoSuchAlgorithmException {
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull((Object)data, (String)"data is required");
        Mac hMacSHA256 = Mac.getInstance("HmacSHA256");
        byte[] hmacKeyBytes = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec secretKey = new SecretKeySpec(hmacKeyBytes, "HmacSHA256");
        hMacSHA256.init(secretKey);
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] res = hMacSHA256.doFinal(dataBytes);
        return DatatypeConverter.printBase64Binary((byte[])res);
    }
}

