/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring;

import ch.rasc.wampspring.message.EventMessage;
import java.util.Collections;
import java.util.Set;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.util.Assert;

public class EventMessenger {
    private final MessageChannel brokerChannel;
    private final MessageChannel clientOutboundChannel;
    private volatile long sendTimeout = -1L;

    public EventMessenger(MessageChannel brokerChannel, MessageChannel clientOutboundChannel) {
        Assert.notNull((Object)brokerChannel, (String)"'brokerChannel' must not be null");
        Assert.notNull((Object)clientOutboundChannel, (String)"'clientOutboundChannel' must not be null");
        this.brokerChannel = brokerChannel;
        this.clientOutboundChannel = clientOutboundChannel;
    }

    public void sendToAll(String topicURI, Object event) {
        this.send(new EventMessage(topicURI, event));
    }

    public void sendToAllExcept(String topicURI, Object event, String excludeWebSocketSessionId) {
        this.sendToAllExcept(topicURI, event, Collections.singleton(excludeWebSocketSessionId));
    }

    public void sendToAllExcept(String topicURI, Object event, Set<String> excludeWebSocketSessionIds) {
        EventMessage eventMessage = new EventMessage(topicURI, event);
        eventMessage.setExcludeWebSocketSessionIds(excludeWebSocketSessionIds);
        this.send(eventMessage);
    }

    public void sendTo(String topicURI, Object event, Set<String> eligibleWebSocketSessionIds) {
        EventMessage eventMessage = new EventMessage(topicURI, event);
        eventMessage.setEligibleWebSocketSessionIds(eligibleWebSocketSessionIds);
        this.send(eventMessage);
    }

    public void sendTo(String topicURI, Object event, String eligibleWebSocketSessionId) {
        this.sendTo(topicURI, event, Collections.singleton(eligibleWebSocketSessionId));
    }

    public void sendToDirect(String topicURI, Object event, Set<String> webSocketSessionIds) {
        if (webSocketSessionIds != null) {
            for (String webSocketSessionId : webSocketSessionIds) {
                EventMessage eventMessage = new EventMessage(topicURI, event);
                eventMessage.setWebSocketSessionId(webSocketSessionId);
                this.sendDirect(eventMessage);
            }
        }
    }

    public void sendToDirect(String topicURI, Object event, String webSocketSessionId) {
        Assert.notNull((Object)webSocketSessionId, (String)"WebSocket session id must not be null");
        this.sendToDirect(topicURI, event, Collections.singleton(webSocketSessionId));
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void send(EventMessage eventMessage) {
        boolean sent;
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? this.brokerChannel.send((Message)eventMessage, timeout) : this.brokerChannel.send((Message)eventMessage);
        if (!sent) {
            throw new MessageDeliveryException((Message)eventMessage, "Failed to send message with destination '" + eventMessage.getDestination() + "' within timeout: " + timeout);
        }
    }

    public void sendDirect(EventMessage eventMessage) {
        boolean sent;
        Assert.notNull((Object)eventMessage.getWebSocketSessionId(), (String)"WebSocket session id must not be null");
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? this.clientOutboundChannel.send((Message)eventMessage, timeout) : this.clientOutboundChannel.send((Message)eventMessage);
        if (!sent) {
            throw new MessageDeliveryException((Message)eventMessage, "Failed to direct send message with destination '" + eventMessage.getDestination() + "' within timeout: " + timeout);
        }
    }
}

