/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.broker;

import ch.rasc.wampspring.broker.SubscriptionRegistry;
import ch.rasc.wampspring.message.PubSubMessage;
import ch.rasc.wampspring.message.SubscribeMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.PathMatcher;

public class DefaultSubscriptionRegistry
implements SubscriptionRegistry {
    private static final int DEFAULT_CACHE_LIMIT = 1024;
    private volatile int cacheLimit = 1024;
    private final PathMatcher pathMatcher;
    private final DestinationCache destinationCache = new DestinationCache();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ConcurrentMap<String, Set<String>> sessionDestinations = new ConcurrentHashMap<String, Set<String>>();
    private final Object monitor = new Object();

    public DefaultSubscriptionRegistry(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    @Override
    public final void registerSubscription(SubscribeMessage subscribeMessage) {
        String sessionId = subscribeMessage.getWebSocketSessionId();
        String destination = subscribeMessage.getTopicURI();
        if (sessionId != null && destination != null) {
            this.addSessionId(sessionId, destination);
            this.destinationCache.updateAfterNewSession(destination, sessionId);
        }
    }

    @Override
    public final void unregisterSubscription(UnsubscribeMessage unsubscribeMessage) {
        String sessionId = unsubscribeMessage.getWebSocketSessionId();
        String destination = unsubscribeMessage.getTopicURI();
        if (sessionId != null && destination != null) {
            this.removeSessionDestination(sessionId, destination);
        }
    }

    @Override
    public final Set<String> findSubscriptions(PubSubMessage pubSubMessge) {
        String destination = pubSubMessge.getDestination();
        return this.findSubscriptionsInternal(destination);
    }

    @Override
    public boolean hasSubscriptions() {
        return !this.sessionDestinations.isEmpty();
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSessionDestination(String sessionId, String destination) {
        Set destinations = (Set)this.sessionDestinations.get(sessionId);
        if (destinations != null) {
            String removedDestination = null;
            String removedSessionId = null;
            Object object = this.monitor;
            synchronized (object) {
                if (destinations.remove(destination)) {
                    removedDestination = destination;
                    if (destinations.isEmpty()) {
                        this.sessionDestinations.remove(sessionId);
                        removedSessionId = sessionId;
                    }
                }
            }
            if (removedDestination != null) {
                this.destinationCache.updateAfterRemovedDestination(sessionId, removedDestination);
            }
            if (removedSessionId != null) {
                this.destinationCache.updateAfterRemovedSession(removedSessionId);
            }
        }
    }

    @Override
    public void unregisterSession(String sessionId) {
        Set destinations = (Set)this.sessionDestinations.remove(sessionId);
        if (destinations != null) {
            this.destinationCache.updateAfterRemovedSession(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> addSessionId(String sessionId, String destination) {
        HashSet<String> destinations = (HashSet<String>)this.sessionDestinations.get(sessionId);
        if (destinations == null) {
            Object object = this.monitor;
            synchronized (object) {
                destinations = (Set)this.sessionDestinations.get(sessionId);
                if (destinations == null) {
                    destinations = new HashSet<String>(4);
                    this.sessionDestinations.put(sessionId, destinations);
                }
            }
        }
        destinations.add(destination);
        return destinations;
    }

    private Set<String> findSubscriptionsInternal(String destination) {
        Set<String> sessionIds = this.destinationCache.getSessionIds(destination);
        if (sessionIds != null) {
            return sessionIds;
        }
        sessionIds = new HashSet<String>();
        for (Map.Entry subscribedSessions : this.sessionDestinations.entrySet()) {
            String sessionId = (String)subscribedSessions.getKey();
            for (String destinationPattern : (Set)subscribedSessions.getValue()) {
                if (!this.pathMatcher.match(destinationPattern, destination)) continue;
                sessionIds.add(sessionId);
            }
        }
        if (!sessionIds.isEmpty()) {
            this.destinationCache.addSessionIds(destination, sessionIds);
        }
        return sessionIds;
    }

    private class DestinationCache {
        private final Map<String, Set<String>> accessCache = new ConcurrentHashMap<String, Set<String>>(1024);
        private final Map<String, Set<String>> updateCache = new LinkedHashMap<String, Set<String>>(1024, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Set<String>> eldest) {
                return this.size() > DefaultSubscriptionRegistry.this.cacheLimit;
            }
        };

        private DestinationCache() {
        }

        public Set<String> getSessionIds(String destination) {
            return this.accessCache.get(destination);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSessionIds(String destination, Set<String> sessionIds) {
            Map<String, Set<String>> map = this.updateCache;
            synchronized (map) {
                this.updateCache.put(destination, new HashSet<String>(sessionIds));
                this.accessCache.put(destination, sessionIds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterNewSession(String destination, String sessionId) {
            Map<String, Set<String>> map = this.updateCache;
            synchronized (map) {
                for (Map.Entry<String, Set<String>> entry : this.updateCache.entrySet()) {
                    String cachedDestination = entry.getKey();
                    if (!DefaultSubscriptionRegistry.this.pathMatcher.match(destination, cachedDestination)) continue;
                    Set<String> sessionIds = entry.getValue();
                    sessionIds.add(sessionId);
                    this.accessCache.put(cachedDestination, new HashSet<String>(sessionIds));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedDestination(String sessionId, String destination) {
            Map<String, Set<String>> map = this.updateCache;
            synchronized (map) {
                Set<String> sessionIds = this.updateCache.get(destination);
                if (sessionIds != null) {
                    sessionIds.remove(sessionId);
                    if (sessionIds.isEmpty()) {
                        this.updateCache.remove(destination);
                        this.accessCache.remove(destination);
                    } else {
                        this.accessCache.put(destination, new HashSet<String>(sessionIds));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAfterRemovedSession(String sessionId) {
            Map<String, Set<String>> map = this.updateCache;
            synchronized (map) {
                HashSet<String> destinationsToRemove = new HashSet<String>();
                for (Map.Entry<String, Set<String>> entry : this.updateCache.entrySet()) {
                    String destination = entry.getKey();
                    Set<String> sessiondIds = entry.getValue();
                    if (!sessiondIds.remove(sessionId)) continue;
                    if (sessiondIds.isEmpty()) {
                        destinationsToRemove.add(destination);
                        continue;
                    }
                    this.accessCache.put(destination, new HashSet<String>(sessiondIds));
                }
                for (String destination : destinationsToRemove) {
                    this.updateCache.remove(destination);
                    this.accessCache.remove(destination);
                }
            }
        }

        public String toString() {
            return "cache[" + this.accessCache.size() + " destination(s)]";
        }
    }
}

