/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.broker;

import ch.rasc.wampspring.broker.SubscriptionRegistry;
import ch.rasc.wampspring.config.WampMessageSelector;
import ch.rasc.wampspring.config.WampSession;
import ch.rasc.wampspring.message.EventMessage;
import ch.rasc.wampspring.message.PubSubMessage;
import ch.rasc.wampspring.message.PublishMessage;
import ch.rasc.wampspring.message.SubscribeMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.message.WampMessageType;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;

public class SimpleBrokerMessageHandler
implements MessageHandler,
SmartLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private final SubscribableChannel brokerChannel;
    private boolean autoStartup = true;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();
    private final SubscriptionRegistry subscriptionRegistry;
    private final WampMessageSelector wampMessageSelector;
    private boolean authenticationRequiredGlobal = false;

    public SimpleBrokerMessageHandler(SubscribableChannel inboundChannel, MessageChannel outboundChannel, SubscribableChannel brokerChannel, SubscriptionRegistry subscriptionRegistry, WampMessageSelector wampMessageSelector) {
        Assert.notNull((Object)inboundChannel, (String)"'inboundChannel' must not be null");
        Assert.notNull((Object)outboundChannel, (String)"'outboundChannel' must not be null");
        Assert.notNull((Object)brokerChannel, (String)"'brokerChannel' must not be null");
        Assert.notNull((Object)subscriptionRegistry, (String)"'subscriptionRegistry' must not be null");
        Assert.notNull((Object)wampMessageSelector, (String)"'wampMessageSelector' must not be null");
        this.clientInboundChannel = inboundChannel;
        this.clientOutboundChannel = outboundChannel;
        this.brokerChannel = brokerChannel;
        this.subscriptionRegistry = subscriptionRegistry;
        this.wampMessageSelector = wampMessageSelector;
    }

    public void setAuthenticationRequiredGlobal(boolean authenticationRequiredGlobal) {
        this.authenticationRequiredGlobal = authenticationRequiredGlobal;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Starting...");
            }
            this.clientInboundChannel.subscribe((MessageHandler)this);
            this.brokerChannel.subscribe((MessageHandler)this);
            this.running = true;
            this.logger.info((Object)"Started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Stopping...");
            }
            this.clientInboundChannel.unsubscribe((MessageHandler)this);
            this.brokerChannel.unsubscribe((MessageHandler)this);
            this.running = false;
            this.logger.info((Object)"Stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    public void handleMessage(Message<?> message) {
        if (!this.running) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this + " not running yet. Ignoring " + message));
            }
            return;
        }
        if (!(message instanceof PubSubMessage) || !this.wampMessageSelector.accept((WampMessage)message)) {
            return;
        }
        WampMessage wampMessage = (WampMessage)message;
        WampMessageType messageType = wampMessage.getType();
        if (messageType == WampMessageType.EVENT) {
            this.sendMessageToSubscribers((EventMessage)wampMessage);
        } else if (messageType == WampMessageType.PUBLISH) {
            this.checkAuthentication(wampMessage);
            this.sendMessageToSubscribers((PublishMessage)wampMessage);
        } else if (messageType == WampMessageType.SUBSCRIBE) {
            this.checkAuthentication(wampMessage);
            this.subscriptionRegistry.registerSubscription((SubscribeMessage)wampMessage);
        } else if (messageType == WampMessageType.UNSUBSCRIBE) {
            UnsubscribeMessage unsubscribeMessage = (UnsubscribeMessage)wampMessage;
            if (unsubscribeMessage.isCleanup()) {
                this.subscriptionRegistry.unregisterSession(unsubscribeMessage.getWebSocketSessionId());
            } else {
                this.checkAuthentication(wampMessage);
                this.subscriptionRegistry.unregisterSubscription(unsubscribeMessage);
            }
        }
    }

    private void checkAuthentication(WampMessage wampMessage) {
        WampSession wampSession = wampMessage.getWampSession();
        if (wampSession != null && !wampSession.isAuthenticated() && this.authenticationRequiredGlobal) {
            throw new SecurityException("Not authenticated");
        }
    }

    protected void sendMessageToSubscribers(EventMessage eventMessage) {
        Set<String> sessionIds = this.subscriptionRegistry.findSubscriptions(eventMessage);
        if (sessionIds.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Broadcasting to " + sessionIds.size() + " sessions."));
            }
            Set<String> eligibleSessionIds = eventMessage.getEligibleWebSocketSessionIds();
            Set<String> excludeSessionIds = eventMessage.getExcludeWebSocketSessionIds();
            for (String sessionId : sessionIds) {
                if (excludeSessionIds != null) {
                    if (excludeSessionIds.contains(sessionId)) continue;
                    this.sendEventMessage(eventMessage, sessionId);
                    continue;
                }
                if (eligibleSessionIds != null) {
                    if (!eligibleSessionIds.contains(sessionId)) continue;
                    this.sendEventMessage(eventMessage, sessionId);
                    continue;
                }
                this.sendEventMessage(eventMessage, sessionId);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No subscriptions found for " + eventMessage));
        }
    }

    protected void sendMessageToSubscribers(PublishMessage publishMessage) {
        Set<String> subscribedSessionIds = this.subscriptionRegistry.findSubscriptions(publishMessage);
        if (subscribedSessionIds.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Broadcasting to " + subscribedSessionIds.size() + " sessions."));
            }
            for (String subscriptionSessionId : subscribedSessionIds) {
                if (!SimpleBrokerMessageHandler.isSessionEligible(publishMessage, subscriptionSessionId)) continue;
                this.sendEventMessage(publishMessage, subscriptionSessionId);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No subscriptions found for " + publishMessage));
        }
    }

    protected void sendEventMessage(EventMessage originEventMessage, String receiverSessionId) {
        EventMessage eventMessage = new EventMessage(originEventMessage, receiverSessionId);
        this.sendEventMessage(eventMessage);
    }

    protected void sendEventMessage(PublishMessage publishMessage, String receiverSessionId) {
        EventMessage eventMessage = new EventMessage(publishMessage, receiverSessionId);
        this.sendEventMessage(eventMessage);
    }

    protected void sendEventMessage(EventMessage eventMessage) {
        try {
            this.clientOutboundChannel.send((Message)eventMessage);
        }
        catch (Throwable ex) {
            this.logger.error((Object)("Failed to send " + eventMessage), ex);
        }
    }

    private static boolean isSessionEligible(PublishMessage publishMessage, String receiverSessionId) {
        String myWebSocketSessionId = publishMessage.getWebSocketSessionId();
        if (publishMessage.getExcludeMe() != null && publishMessage.getExcludeMe().booleanValue() && myWebSocketSessionId.equals(receiverSessionId)) {
            return false;
        }
        if (publishMessage.getEligible() != null && !publishMessage.getEligible().contains(receiverSessionId)) {
            return false;
        }
        return publishMessage.getExclude() == null || !publishMessage.getExclude().contains(receiverSessionId);
    }

    public String toString() {
        return "SimpleBrokerMessageHandler [" + this.subscriptionRegistry + "]";
    }
}

