/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import ch.rasc.wampspring.config.WampWebSocketEndpointRegistration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.OriginHandshakeInterceptor;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.springframework.web.socket.sockjs.transport.TransportHandler;
import org.springframework.web.socket.sockjs.transport.handler.WebSocketTransportHandler;

public class WebMvcWampWebSocketEndpointRegistration
implements WampWebSocketEndpointRegistration {
    private final String[] paths;
    private final WebSocketHandler webSocketHandler;
    private final TaskScheduler sockJsTaskScheduler;
    private HandshakeHandler handshakeHandler;
    private final List<HandshakeInterceptor> interceptors = new ArrayList<HandshakeInterceptor>();
    private final List<String> allowedOrigins = new ArrayList<String>();
    private WampSockJsServiceRegistration registration;

    public WebMvcWampWebSocketEndpointRegistration(String[] paths, WebSocketHandler webSocketHandler, TaskScheduler sockJsTaskScheduler) {
        Assert.notEmpty((Object[])paths, (String)"No paths specified");
        Assert.notNull((Object)webSocketHandler, (String)"WebSocketHandler must not be null");
        this.paths = paths;
        this.webSocketHandler = webSocketHandler;
        this.sockJsTaskScheduler = sockJsTaskScheduler;
    }

    @Override
    public WampWebSocketEndpointRegistration setHandshakeHandler(HandshakeHandler handshakeHandler) {
        Assert.notNull((Object)handshakeHandler, (String)"'handshakeHandler' must not be null");
        this.handshakeHandler = handshakeHandler;
        return this;
    }

    @Override
    public WampWebSocketEndpointRegistration addInterceptors(HandshakeInterceptor ... handshakeInterceptors) {
        if (!ObjectUtils.isEmpty((Object[])handshakeInterceptors)) {
            this.interceptors.addAll(Arrays.asList(handshakeInterceptors));
        }
        return this;
    }

    @Override
    public WampWebSocketEndpointRegistration setAllowedOrigins(String ... origins) {
        this.allowedOrigins.clear();
        if (!ObjectUtils.isEmpty((Object[])origins)) {
            this.allowedOrigins.addAll(Arrays.asList(origins));
        }
        return this;
    }

    @Override
    public SockJsServiceRegistration withSockJS() {
        this.registration = new WampSockJsServiceRegistration(this.sockJsTaskScheduler);
        HandshakeInterceptor[] handshakeInterceptors = this.getInterceptors();
        if (handshakeInterceptors.length > 0) {
            this.registration.setInterceptors(handshakeInterceptors);
        }
        if (this.handshakeHandler != null) {
            WebSocketTransportHandler transportHandler = new WebSocketTransportHandler(this.handshakeHandler);
            this.registration.setTransportHandlerOverrides(new TransportHandler[]{transportHandler});
        }
        if (!this.allowedOrigins.isEmpty()) {
            this.registration.setAllowedOrigins(this.allowedOrigins.toArray(new String[this.allowedOrigins.size()]));
        }
        return this.registration;
    }

    protected HandshakeInterceptor[] getInterceptors() {
        ArrayList<Object> handshakeInterceptors = new ArrayList<Object>();
        handshakeInterceptors.addAll(this.interceptors);
        handshakeInterceptors.add(new OriginHandshakeInterceptor(this.allowedOrigins));
        return handshakeInterceptors.toArray(new HandshakeInterceptor[handshakeInterceptors.size()]);
    }

    public final MultiValueMap<HttpRequestHandler, String> getMappings() {
        LinkedMultiValueMap mappings = new LinkedMultiValueMap();
        if (this.registration != null) {
            SockJsService sockJsService = this.registration.getSockJsService();
            for (String path : this.paths) {
                String pattern = path.endsWith("/") ? path + "**" : path + "/**";
                SockJsHttpRequestHandler handler = new SockJsHttpRequestHandler(sockJsService, this.webSocketHandler);
                mappings.add((Object)handler, (Object)pattern);
            }
        } else {
            for (String path : this.paths) {
                WebSocketHttpRequestHandler handler = this.handshakeHandler != null ? new WebSocketHttpRequestHandler(this.webSocketHandler, this.handshakeHandler) : new WebSocketHttpRequestHandler(this.webSocketHandler);
                HandshakeInterceptor[] handshakeInterceptors = this.getInterceptors();
                if (handshakeInterceptors.length > 0) {
                    handler.setHandshakeInterceptors(Arrays.asList(handshakeInterceptors));
                }
                mappings.add((Object)handler, (Object)path);
            }
        }
        return mappings;
    }

    private static class WampSockJsServiceRegistration
    extends SockJsServiceRegistration {
        public WampSockJsServiceRegistration(TaskScheduler defaultTaskScheduler) {
            super(defaultTaskScheduler);
        }

        protected SockJsService getSockJsService() {
            return super.getSockJsService();
        }

        protected SockJsServiceRegistration setAllowedOrigins(String ... origins) {
            return super.setAllowedOrigins(origins);
        }
    }
}

