/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.message;

import ch.rasc.wampspring.config.WampSession;
import ch.rasc.wampspring.message.CallErrorMessage;
import ch.rasc.wampspring.message.CallMessage;
import ch.rasc.wampspring.message.CallResultMessage;
import ch.rasc.wampspring.message.EventMessage;
import ch.rasc.wampspring.message.PrefixMessage;
import ch.rasc.wampspring.message.PublishMessage;
import ch.rasc.wampspring.message.SubscribeMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessageHeader;
import ch.rasc.wampspring.message.WampMessageType;
import ch.rasc.wampspring.message.WelcomeMessage;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.handler.annotation.support.DestinationVariableMethodArgumentResolver;
import org.springframework.web.socket.WebSocketSession;

public abstract class WampMessage
implements Message<Object> {
    protected static final Object EMPTY_OBJECT = new Object();
    private final MutableMessageHeaders messageHeaders = new MutableMessageHeaders();

    WampMessage(WampMessageType type) {
        this.setHeader(WampMessageHeader.WAMP_MESSAGE_TYPE, (Object)type);
    }

    int getTypeId() {
        return this.getType().getTypeId();
    }

    public WampMessageType getType() {
        return (WampMessageType)((Object)this.getHeader(WampMessageHeader.WAMP_MESSAGE_TYPE));
    }

    public void setHeader(WampMessageHeader header, Object value) {
        this.messageHeaders.getRawHeaders().put(header.name(), value);
    }

    public <T> T getHeader(WampMessageHeader header) {
        return (T)this.messageHeaders.get(header.name());
    }

    public void setDestinationTemplateVariables(Map<String, String> vars) {
        this.messageHeaders.getRawHeaders().put(DestinationVariableMethodArgumentResolver.DESTINATION_TEMPLATE_VARIABLES_HEADER, vars);
    }

    public String getWebSocketSessionId() {
        return (String)this.getHeader(WampMessageHeader.WEBSOCKET_SESSION_ID);
    }

    public void setWebSocketSessionId(String webSocketSessionId) {
        this.setHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, webSocketSessionId);
    }

    public String getDestination() {
        return null;
    }

    public Principal getPrincipal() {
        return (Principal)this.getHeader(WampMessageHeader.PRINCIPAL);
    }

    void setPrincipal(Principal principal) {
        this.setHeader(WampMessageHeader.PRINCIPAL, principal);
    }

    public WampSession getWampSession() {
        return (WampSession)this.getHeader(WampMessageHeader.WAMP_SESSION);
    }

    void setWampSession(WampSession wampSession) {
        this.setHeader(WampMessageHeader.WAMP_SESSION, wampSession);
    }

    public Object getPayload() {
        return EMPTY_OBJECT;
    }

    public MessageHeaders getHeaders() {
        return this.messageHeaders;
    }

    public static <T extends WampMessage> T fromJson(WebSocketSession session, JsonFactory jsonFactory, String json) throws IOException {
        WampSession wampSession = new WampSession(session);
        T newWampMessage = WampMessage.fromJson(jsonFactory, json, wampSession);
        ((WampMessage)newWampMessage).setWebSocketSessionId(session.getId());
        ((WampMessage)newWampMessage).setPrincipal(session.getPrincipal());
        ((WampMessage)newWampMessage).setWampSession(wampSession);
        return newWampMessage;
    }

    public abstract String toJson(JsonFactory var1) throws IOException;

    public static <T extends WampMessage> T fromJson(JsonFactory jsonFactory, String json) throws IOException {
        return WampMessage.fromJson(jsonFactory, json, null);
    }

    public static <T extends WampMessage> T fromJson(JsonFactory jsonFactory, String json, WampSession wampSession) throws IOException {
        try (JsonParser jp = jsonFactory.createParser(json);){
            if (jp.nextToken() != JsonToken.START_ARRAY) {
                throw new IOException("Not a JSON array");
            }
            if (jp.nextToken() != JsonToken.VALUE_NUMBER_INT) {
                throw new IOException("Wrong message format");
            }
            WampMessageType messageType = WampMessageType.fromTypeId(jp.getValueAsInt());
            switch (messageType) {
                case WELCOME: {
                    WelcomeMessage welcomeMessage = new WelcomeMessage(jp);
                    return (T)welcomeMessage;
                }
                case PREFIX: {
                    PrefixMessage prefixMessage = new PrefixMessage(jp);
                    return (T)prefixMessage;
                }
                case CALL: {
                    CallMessage callMessage = new CallMessage(jp, wampSession);
                    return (T)callMessage;
                }
                case CALLRESULT: {
                    CallResultMessage callResultMessage = new CallResultMessage(jp);
                    return (T)callResultMessage;
                }
                case CALLERROR: {
                    CallErrorMessage callErrorMessage = new CallErrorMessage(jp);
                    return (T)callErrorMessage;
                }
                case SUBSCRIBE: {
                    SubscribeMessage subscribeMessage = new SubscribeMessage(jp, wampSession);
                    return (T)subscribeMessage;
                }
                case UNSUBSCRIBE: {
                    UnsubscribeMessage unsubscribeMessage = new UnsubscribeMessage(jp, wampSession);
                    return (T)unsubscribeMessage;
                }
                case PUBLISH: {
                    PublishMessage publishMessage = new PublishMessage(jp, wampSession);
                    return (T)publishMessage;
                }
                case EVENT: {
                    EventMessage eventMessage = new EventMessage(jp, wampSession);
                    return (T)eventMessage;
                }
            }
            T t = null;
            return t;
        }
    }

    protected String replacePrefix(String uri, WampSession wampSession) {
        String prefix;
        String[] curie;
        if (uri != null && wampSession != null && wampSession.hasPrefixes() && (curie = uri.split(":")).length == 2 && (prefix = wampSession.getPrefix(curie[0])) != null) {
            return prefix + curie[1];
        }
        return uri;
    }

    private static class MutableMessageHeaders
    extends MessageHeaders {
        public MutableMessageHeaders() {
            super(null, MessageHeaders.ID_VALUE_NONE, Long.valueOf(-1L));
        }

        public Map<String, Object> getRawHeaders() {
            return super.getRawHeaders();
        }
    }
}

