/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import ch.rasc.wampspring.message.WampMessageHeader;
import ch.rasc.wampspring.message.WampMessageType;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.AbstractMessageCondition;
import org.springframework.util.Assert;

public class WampMessageTypeMessageCondition
extends AbstractMessageCondition<WampMessageTypeMessageCondition> {
    public static final WampMessageTypeMessageCondition CALL = new WampMessageTypeMessageCondition(WampMessageType.CALL);
    public static final WampMessageTypeMessageCondition PUBLISH = new WampMessageTypeMessageCondition(WampMessageType.PUBLISH);
    public static final WampMessageTypeMessageCondition SUBSCRIBE = new WampMessageTypeMessageCondition(WampMessageType.SUBSCRIBE);
    public static final WampMessageTypeMessageCondition UNSUBSCRIBE = new WampMessageTypeMessageCondition(WampMessageType.UNSUBSCRIBE);
    private final WampMessageType messageType;

    public WampMessageTypeMessageCondition(WampMessageType messageType) {
        Assert.notNull((Object)((Object)messageType), (String)"MessageType must not be null");
        this.messageType = messageType;
    }

    public WampMessageType getMessageType() {
        return this.messageType;
    }

    protected Collection<?> getContent() {
        return Arrays.asList(this.messageType);
    }

    protected String getToStringInfix() {
        return " || ";
    }

    public WampMessageTypeMessageCondition combine(WampMessageTypeMessageCondition other) {
        return other;
    }

    public WampMessageTypeMessageCondition getMatchingCondition(Message<?> message) {
        WampMessageType actualMessageType = (WampMessageType)((Object)message.getHeaders().get((Object)WampMessageHeader.WAMP_MESSAGE_TYPE.name()));
        if (actualMessageType != this.messageType) {
            return null;
        }
        return this;
    }

    public int compareTo(WampMessageTypeMessageCondition other, Message<?> message) {
        WampMessageType actualMessageType = (WampMessageType)((Object)message.getHeaders().get((Object)WampMessageHeader.WAMP_MESSAGE_TYPE.name()));
        if (actualMessageType != null) {
            if (actualMessageType == this.getMessageType() && actualMessageType == other.getMessageType()) {
                return 0;
            }
            if (actualMessageType == this.getMessageType()) {
                return -1;
            }
            if (actualMessageType == other.getMessageType()) {
                return 1;
            }
        }
        return 0;
    }
}

