/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.user;

import ch.rasc.wampspring.EventMessenger;
import ch.rasc.wampspring.message.EventMessage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.Assert;

public class UserEventMessenger {
    private final EventMessenger eventMessenger;
    private final UserSessionRegistry userSessionRegistry;

    public UserEventMessenger(EventMessenger eventMessenger, UserSessionRegistry userSessionRegistry) {
        Assert.notNull((Object)eventMessenger, (String)"'eventMessenger' must not be null");
        Assert.notNull((Object)userSessionRegistry, (String)"'userSessionRegistry' must not be null");
        this.eventMessenger = eventMessenger;
        this.userSessionRegistry = userSessionRegistry;
    }

    public void setSendTimeout(long sendTimeout) {
        this.eventMessenger.setSendTimeout(sendTimeout);
    }

    public void send(EventMessage eventMessage) {
        this.eventMessenger.send(eventMessage);
    }

    public void sendToAll(String topicURI, Object event) {
        this.eventMessenger.sendToAll(topicURI, event);
    }

    public void sendToAllExcept(String topicURI, Object event, String excludeSessionId) {
        this.eventMessenger.sendToAllExcept(topicURI, event, excludeSessionId);
    }

    public void sendToAllExcept(String topicURI, Object event, Set<String> excludeSessionIds) {
        this.eventMessenger.sendToAllExcept(topicURI, event, excludeSessionIds);
    }

    public void sendTo(String topicURI, Object event, Set<String> eligibleSessionIds) {
        this.eventMessenger.sendTo(topicURI, event, eligibleSessionIds);
    }

    public void sendTo(String topicURI, Object event, String eligibleSessionId) {
        this.eventMessenger.sendTo(topicURI, event, eligibleSessionId);
    }

    public void sendToDirect(String topicURI, Object event, Set<String> webSocketSessionIds) {
        this.eventMessenger.sendToDirect(topicURI, event, webSocketSessionIds);
    }

    public void sendToDirect(String topicURI, Object event, String webSocketSessionId) {
        this.eventMessenger.sendToDirect(topicURI, event, webSocketSessionId);
    }

    public void sendDirect(EventMessage eventMessage) {
        this.eventMessenger.sendDirect(eventMessage);
    }

    public void sendToAllExceptUser(String topicURI, Object event, String excludeUser) {
        this.sendToAllExceptUsers(topicURI, event, Collections.singleton(excludeUser));
    }

    public void sendToAllExceptUsers(String topicURI, Object event, Set<String> excludeUsers) {
        HashSet excludeSessionIds = null;
        if (excludeUsers != null && !excludeUsers.isEmpty()) {
            excludeSessionIds = new HashSet(excludeUsers.size());
            for (String user : excludeUsers) {
                excludeSessionIds.addAll(this.userSessionRegistry.getSessionIds(user));
            }
        }
        this.eventMessenger.sendToAllExcept(topicURI, event, excludeSessionIds);
    }

    public void sendToUsers(String topicURI, Object event, Set<String> eligibleUsers) {
        HashSet eligibleSessionIds = null;
        if (eligibleUsers != null && !eligibleUsers.isEmpty()) {
            eligibleSessionIds = new HashSet(eligibleUsers.size());
            for (String user : eligibleUsers) {
                eligibleSessionIds.addAll(this.userSessionRegistry.getSessionIds(user));
            }
        }
        this.eventMessenger.sendTo(topicURI, event, eligibleSessionIds);
    }

    public void sendToUser(String topicURI, Object event, String eligibleUser) {
        this.sendToUsers(topicURI, event, Collections.singleton(eligibleUser));
    }

    public void sendToUsersDirect(String topicURI, Object event, Set<String> users) {
        HashSet webSocketSessionIds = null;
        if (users != null && !users.isEmpty()) {
            webSocketSessionIds = new HashSet(users.size());
            for (String user : users) {
                webSocketSessionIds.addAll(this.userSessionRegistry.getSessionIds(user));
            }
        }
        this.eventMessenger.sendToDirect(topicURI, event, webSocketSessionIds);
    }

    public void sendToUserDirect(String topicURI, Object event, String user) {
        this.sendToUsersDirect(topicURI, event, Collections.singleton(user));
    }
}

