/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.config;

import ch.rasc.wampspring.config.WampSession;
import ch.rasc.wampspring.message.WampMessage;
import org.springframework.core.NamedThreadLocal;

public abstract class WampSessionContextHolder {
    private static final ThreadLocal<WampSession> attributesHolder = new NamedThreadLocal("WAMP session attributes");

    public static void resetAttributes() {
        attributesHolder.remove();
    }

    public static void setAttributes(WampSession attributes) {
        if (attributes != null) {
            attributesHolder.set(attributes);
        } else {
            WampSessionContextHolder.resetAttributes();
        }
    }

    public static void setAttributesFromMessage(WampMessage message) {
        WampSessionContextHolder.setAttributes(message.getWampSession());
    }

    public static WampSession getAttributes() {
        return attributesHolder.get();
    }

    public static WampSession currentAttributes() throws IllegalStateException {
        WampSession attributes = WampSessionContextHolder.getAttributes();
        if (attributes == null) {
            throw new IllegalStateException("No thread-bound WampSession found. Your code is probably not processing a client message and executing in message-handling methods invoked by the WampAnnotationMethodMessageHandler?");
        }
        return attributes;
    }
}

