/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.method.MethodParameterConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.util.ReflectionUtils;

public class InvocableWampHandlerMethod
extends HandlerMethod {
    private HandlerMethodArgumentResolver argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final MethodParameterConverter methodParameterConverter;

    public InvocableWampHandlerMethod(HandlerMethod handlerMethod, MethodParameterConverter methodParameterConverter) {
        super(handlerMethod);
        this.methodParameterConverter = methodParameterConverter;
    }

    public void setMessageMethodArgumentResolvers(HandlerMethodArgumentResolver argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public Object invoke(WampMessage message, Object ... providedArgs) throws Exception {
        Object[] args = this.getMethodArgumentValues(message, providedArgs);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Resolved arguments: " + Arrays.asList(args)));
        }
        Object returnValue = this.doInvoke(args);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Returned value: " + returnValue));
        }
        return returnValue;
    }

    private Object[] getMethodArgumentValues(WampMessage message, Object ... providedArgs) throws Exception {
        MethodParameter[] parameters = this.getMethodParameters();
        Object[] args = new Object[parameters.length];
        int argIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            GenericTypeResolver.resolveParameterType((MethodParameter)parameter, this.getBean().getClass());
            if (this.argumentResolvers.supportsParameter(parameter)) {
                try {
                    args[i] = this.argumentResolvers.resolveArgument(parameter, (Message)message);
                    continue;
                }
                catch (Exception ex) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)this.getArgumentResolutionErrorMessage("Error resolving argument", i), (Throwable)ex);
                    }
                    throw ex;
                }
            }
            if (providedArgs != null) {
                args[i] = this.methodParameterConverter.convert(parameter, providedArgs[argIndex]);
                if (args[i] != null) {
                    ++argIndex;
                    continue;
                }
            }
            if (args[i] != null) continue;
            String error = this.getArgumentResolutionErrorMessage("No suitable resolver for argument", i);
            throw new IllegalStateException(error);
        }
        return args;
    }

    private String getArgumentResolutionErrorMessage(String message, int index) {
        MethodParameter param = this.getMethodParameters()[index];
        String msg = message + " [" + index + "] [type=" + param.getParameterType().getName() + "]";
        return this.getDetailedErrorMessage(msg);
    }

    protected String getDetailedErrorMessage(String message) {
        StringBuilder sb = new StringBuilder(message).append("\n");
        sb.append("HandlerMethod details: \n");
        sb.append("Bean [").append(this.getBeanType().getName()).append("]\n");
        sb.append("Method [").append(this.getBridgedMethod().toGenericString()).append("]\n");
        return sb.toString();
    }

    protected Object doInvoke(Object ... args) throws Exception {
        ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
        try {
            return this.getBridgedMethod().invoke(this.getBean(), args);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(this.getBridgedMethod(), this.getBean(), args);
            throw new IllegalStateException(this.getInvocationErrorMessage(ex.getMessage(), args), ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            String msg = this.getInvocationErrorMessage("Failed to invoke controller method", args);
            throw new IllegalStateException(msg, targetException);
        }
    }

    private void assertTargetBean(Method method, Object targetBean, Object[] args) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String msg = "The mapped controller method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual controller bean instance '" + targetBeanClass.getName() + "'. If the controller requires proxying (e.g. due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.getInvocationErrorMessage(msg, args));
        }
    }

    private String getInvocationErrorMessage(String message, Object[] resolvedArgs) {
        StringBuilder sb = new StringBuilder(this.getDetailedErrorMessage(message));
        sb.append("Resolved arguments: \n");
        for (int i = 0; i < resolvedArgs.length; ++i) {
            sb.append("[").append(i).append("] ");
            if (resolvedArgs[i] == null) {
                sb.append("[null] \n");
                continue;
            }
            sb.append("[type=").append(resolvedArgs[i].getClass().getName()).append("] ");
            sb.append("[value=").append(resolvedArgs[i]).append("]\n");
        }
        return sb.toString();
    }
}

