/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import ch.rasc.wampspring.EventMessenger;
import ch.rasc.wampspring.annotation.WampAuthenticated;
import ch.rasc.wampspring.annotation.WampCallListener;
import ch.rasc.wampspring.annotation.WampPublishListener;
import ch.rasc.wampspring.annotation.WampSubscribeListener;
import ch.rasc.wampspring.annotation.WampUnsubscribeListener;
import ch.rasc.wampspring.config.WampMessageSelector;
import ch.rasc.wampspring.config.WampSession;
import ch.rasc.wampspring.config.WampSessionContextHolder;
import ch.rasc.wampspring.message.CallErrorMessage;
import ch.rasc.wampspring.message.CallMessage;
import ch.rasc.wampspring.message.CallResultMessage;
import ch.rasc.wampspring.message.PublishMessage;
import ch.rasc.wampspring.message.SubscribeMessage;
import ch.rasc.wampspring.message.UnsubscribeMessage;
import ch.rasc.wampspring.message.WampMessage;
import ch.rasc.wampspring.method.DestinationPatternsMessageCondition;
import ch.rasc.wampspring.method.InvocableWampHandlerMethod;
import ch.rasc.wampspring.method.MethodParameterConverter;
import ch.rasc.wampspring.method.PayloadArgumentResolver;
import ch.rasc.wampspring.method.PrincipalMethodArgumentResolver;
import ch.rasc.wampspring.method.WampHandlerMethod;
import ch.rasc.wampspring.method.WampMessageMappingInfo;
import ch.rasc.wampspring.method.WampMessageTypeMessageCondition;
import ch.rasc.wampspring.method.WampSessionMethodArgumentResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.DestinationVariableMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class WampAnnotationMethodMessageHandler
implements MessageHandler,
ApplicationContextAware,
InitializingBean,
SmartLifecycle {
    private final Object lifecycleMonitor = new Object();
    private volatile boolean running = false;
    private volatile long sendTimeout = -1L;
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private final EventMessenger eventMessenger;
    private final MethodParameterConverter methodParameterConverter;
    private final PathMatcher pathMatcher;
    private final WampMessageSelector wampMessageSelector;
    private boolean authenticationRequiredGlobal = false;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ConversionService conversionService;
    private final List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(4);
    private final HandlerMethodArgumentResolverComposite argumentResolvers = new HandlerMethodArgumentResolverComposite();
    private ApplicationContext applicationContext;
    private final MultiValueMap<WampMessageMappingInfo, WampHandlerMethod> handlerMethods = new LinkedMultiValueMap();
    private final MultiValueMap<String, WampMessageMappingInfo> destinationLookup = new LinkedMultiValueMap();
    private final MessageConverter messageConverter;

    public WampAnnotationMethodMessageHandler(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel, EventMessenger eventMessenger, ConversionService conversionService, MethodParameterConverter methodParameterConverter, PathMatcher pathMatcher, WampMessageSelector wampMessageSelector, MessageConverter messageConverter) {
        this.clientInboundChannel = clientInboundChannel;
        this.clientOutboundChannel = clientOutboundChannel;
        this.eventMessenger = eventMessenger;
        this.conversionService = conversionService;
        this.methodParameterConverter = methodParameterConverter;
        this.pathMatcher = pathMatcher;
        this.wampMessageSelector = wampMessageSelector;
        this.messageConverter = messageConverter;
    }

    public void setAuthenticationRequiredGlobal(boolean authenticationRequiredGlobal) {
        this.authenticationRequiredGlobal = authenticationRequiredGlobal;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe((MessageHandler)this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientInboundChannel.unsubscribe((MessageHandler)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    private List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ConfigurableListableBeanFactory beanFactory = ClassUtils.isAssignableValue(ConfigurableApplicationContext.class, (Object)this.applicationContext) ? ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory() : null;
        ArrayList<Object> resolvers = new ArrayList<Object>();
        resolvers.add(new HeaderMethodArgumentResolver(this.conversionService, (ConfigurableBeanFactory)beanFactory));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new DestinationVariableMethodArgumentResolver(this.conversionService));
        resolvers.add(new PrincipalMethodArgumentResolver());
        resolvers.add(new WampSessionMethodArgumentResolver());
        resolvers.add(new MessageMethodArgumentResolver(this.messageConverter));
        resolvers.addAll(this.getCustomArgumentResolvers());
        resolvers.add(new PayloadArgumentResolver(this.applicationContext, this.methodParameterConverter));
        return resolvers;
    }

    private void handleMatchInternal(WampHandlerMethod handlerMethod, WampMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking " + handlerMethod.getShortLogMessage()));
        }
        switch (message.getType()) {
            case CALL: {
                this.handleCallMessage((CallMessage)message, handlerMethod);
                break;
            }
            case PUBLISH: {
                PublishMessage publishMessage = (PublishMessage)message;
                this.handlePubSubMessage(publishMessage, publishMessage.getEvent(), handlerMethod);
                break;
            }
            case SUBSCRIBE: {
                SubscribeMessage subscribeMessage = (SubscribeMessage)message;
                this.handlePubSubMessage(subscribeMessage, null, handlerMethod);
                break;
            }
            case UNSUBSCRIBE: {
                UnsubscribeMessage unsubscribeMessage = (UnsubscribeMessage)message;
                this.handlePubSubMessage(unsubscribeMessage, null, handlerMethod);
                break;
            }
        }
    }

    private static void checkAuthentication(WampHandlerMethod handlerMethod, WampMessage message) {
        WampSession wampSession = message.getWampSession();
        if (!(wampSession == null || wampSession.isAuthenticated() || !handlerMethod.isAuthenticationRequired() || message instanceof UnsubscribeMessage && ((UnsubscribeMessage)message).isCleanup())) {
            throw new SecurityException("Not authenticated");
        }
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        if (!(message instanceof WampMessage) || !this.wampMessageSelector.accept((WampMessage)message)) {
            return;
        }
        WampMessage wampMessage = (WampMessage)message;
        String destination = wampMessage.getDestination();
        if (destination == null) {
            return;
        }
        this.handleMessageInternal(wampMessage, destination);
    }

    private void handleCallMessage(CallMessage callMessage, WampHandlerMethod handlerMethod) {
        try {
            WampAnnotationMethodMessageHandler.checkAuthentication(handlerMethod, callMessage);
            InvocableWampHandlerMethod invocable = new InvocableWampHandlerMethod(handlerMethod.createWithResolvedBean(), this.methodParameterConverter);
            invocable.setMessageMethodArgumentResolvers((HandlerMethodArgumentResolver)this.argumentResolvers);
            Object[] arguments = null;
            if (callMessage.getArguments() != null) {
                arguments = callMessage.getArguments().toArray();
            }
            Object returnValue = invocable.invoke(callMessage, arguments);
            CallResultMessage callResultMessage = new CallResultMessage(callMessage, returnValue);
            this.send(callResultMessage);
        }
        catch (Exception ex) {
            CallErrorMessage callErrorMessage = new CallErrorMessage(callMessage, "", ex.toString());
            this.send(callErrorMessage);
            this.logger.error((Object)("Error while processing message " + callMessage), (Throwable)ex);
        }
        catch (Throwable t) {
            CallErrorMessage callErrorMessage = new CallErrorMessage(callMessage, "", t.toString());
            this.send(callErrorMessage);
            this.logger.error((Object)("Error while processing message " + callErrorMessage), t);
        }
    }

    public void send(WampMessage wampMessage) {
        boolean sent;
        long timeout = this.sendTimeout;
        boolean bl = sent = timeout >= 0L ? this.clientOutboundChannel.send((Message)wampMessage, timeout) : this.clientOutboundChannel.send((Message)wampMessage);
        if (!sent) {
            throw new MessageDeliveryException((Message)wampMessage, "Failed to send message with destination '" + wampMessage.getDestination() + "' within timeout: " + timeout);
        }
    }

    private void handlePubSubMessage(WampMessage wampMessage, Object argument, WampHandlerMethod wampHandlerMethod) {
        try {
            WampAnnotationMethodMessageHandler.checkAuthentication(wampHandlerMethod, wampMessage);
            InvocableWampHandlerMethod invocable = new InvocableWampHandlerMethod(wampHandlerMethod.createWithResolvedBean(), this.methodParameterConverter);
            invocable.setMessageMethodArgumentResolvers((HandlerMethodArgumentResolver)this.argumentResolvers);
            Object returnValue = invocable.invoke(wampMessage, argument);
            if (returnValue != null) {
                for (String replyToTopicURI : wampHandlerMethod.getReplyTo()) {
                    if (!StringUtils.hasText((String)replyToTopicURI)) continue;
                    if (wampHandlerMethod.isBroadcast()) {
                        if (wampHandlerMethod.isExcludeSender()) {
                            this.eventMessenger.sendToAllExcept(replyToTopicURI, returnValue, wampMessage.getWebSocketSessionId());
                            continue;
                        }
                        this.eventMessenger.sendToAll(replyToTopicURI, returnValue);
                        continue;
                    }
                    if (wampHandlerMethod.isExcludeSender()) continue;
                    this.eventMessenger.sendTo(replyToTopicURI, returnValue, wampMessage.getWebSocketSessionId());
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)("Error while processing message " + wampMessage), ex);
        }
    }

    private <A extends Annotation> void detectHandlerMethods(String beanName, Class<?> userType, final Class<A> annotationType) {
        Set methods = MethodIntrospector.selectMethods(userType, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null;
            }
        });
        for (Method method : methods) {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, annotationType);
            String[] replyTo = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)"replyTo");
            Boolean excludeSender = (Boolean)AnnotationUtils.getValue((Annotation)annotation, (String)"excludeSender");
            Boolean broadcast = (Boolean)AnnotationUtils.getValue((Annotation)annotation, (String)"broadcast");
            boolean authenticationRequiredClass = AnnotationUtils.findAnnotation(userType, WampAuthenticated.class) != null;
            boolean[] authenticationRequiredMethod = (boolean[])AnnotationUtils.getValue((Annotation)annotation, (String)"authenticated");
            boolean authenticationRequired = false;
            if (authenticationRequiredMethod != null && authenticationRequiredMethod.length == 1) {
                authenticationRequired = authenticationRequiredMethod[0];
            } else if (authenticationRequiredClass || this.authenticationRequiredGlobal) {
                authenticationRequired = true;
            }
            WampHandlerMethod newHandlerMethod = new WampHandlerMethod(beanName, (BeanFactory)this.applicationContext, method, replyTo, broadcast, excludeSender, authenticationRequired);
            String[] destinations = (String[])AnnotationUtils.getValue((Annotation)annotation);
            if (destinations.length == 0) {
                destinations = new String[]{beanName + "." + method.getName()};
            }
            WampMessageMappingInfo mapping = null;
            if (annotationType.equals(WampCallListener.class)) {
                mapping = new WampMessageMappingInfo(WampMessageTypeMessageCondition.CALL, new DestinationPatternsMessageCondition(destinations, this.pathMatcher));
            } else if (annotationType.equals(WampPublishListener.class)) {
                mapping = new WampMessageMappingInfo(WampMessageTypeMessageCondition.PUBLISH, new DestinationPatternsMessageCondition(destinations, this.pathMatcher));
            } else if (annotationType.equals(WampSubscribeListener.class)) {
                mapping = new WampMessageMappingInfo(WampMessageTypeMessageCondition.SUBSCRIBE, new DestinationPatternsMessageCondition(destinations, this.pathMatcher));
            } else if (annotationType.equals(WampUnsubscribeListener.class)) {
                mapping = new WampMessageMappingInfo(WampMessageTypeMessageCondition.UNSUBSCRIBE, new DestinationPatternsMessageCondition(destinations, this.pathMatcher));
            }
            this.registerHandlerMethod(newHandlerMethod, mapping);
        }
    }

    private void registerHandlerMethod(WampHandlerMethod newHandlerMethod, WampMessageMappingInfo mapping) {
        this.handlerMethods.add((Object)mapping, (Object)newHandlerMethod);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Mapped \"" + mapping + "\" onto " + (Object)((Object)newHandlerMethod)));
        }
        for (String pattern : this.getDirectLookupDestinations(mapping)) {
            this.destinationLookup.add((Object)pattern, (Object)mapping);
        }
    }

    private void detectHandlerMethods(String beanName) {
        Class handlerType = this.applicationContext.getType(beanName);
        Class userType = ClassUtils.getUserClass((Class)handlerType);
        this.detectHandlerMethods(beanName, userType, WampCallListener.class);
        this.detectHandlerMethods(beanName, userType, WampPublishListener.class);
        this.detectHandlerMethods(beanName, userType, WampSubscribeListener.class);
        this.detectHandlerMethods(beanName, userType, WampUnsubscribeListener.class);
    }

    private Set<String> getDirectLookupDestinations(WampMessageMappingInfo mapping) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String pattern : mapping.getDestinationConditions().getPatterns()) {
            if (this.pathMatcher.isPattern(pattern)) continue;
            result.add(pattern);
        }
        return result;
    }

    public void setCustomArgumentResolvers(List<HandlerMethodArgumentResolver> customArgumentResolvers) {
        this.customArgumentResolvers.clear();
        if (customArgumentResolvers != null) {
            this.customArgumentResolvers.addAll(customArgumentResolvers);
        }
    }

    public List<HandlerMethodArgumentResolver> getCustomArgumentResolvers() {
        return this.customArgumentResolvers;
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        if (argumentResolvers == null) {
            this.argumentResolvers.clear();
            return;
        }
        this.argumentResolvers.addResolvers(argumentResolvers);
    }

    public List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        return this.argumentResolvers.getResolvers();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        if (this.argumentResolvers.getResolvers().isEmpty()) {
            this.argumentResolvers.addResolvers(this.initArgumentResolvers());
        }
        for (String beanName : this.applicationContext.getBeanNamesForType(Object.class)) {
            this.detectHandlerMethods(beanName);
        }
    }

    private void handleMessageInternal(WampMessage message, String lookupDestination) {
        ArrayList<Match> matches = new ArrayList<Match>();
        List mappingsByUrl = (List)this.destinationLookup.get((Object)lookupDestination);
        if (mappingsByUrl != null) {
            this.addMatchesToCollection(mappingsByUrl, message, matches);
        }
        if (matches.isEmpty()) {
            Set allMappings = this.handlerMethods.keySet();
            this.addMatchesToCollection(allMappings, message, matches);
        }
        if (matches.isEmpty()) {
            this.handleNoMatch(this.handlerMethods.keySet(), lookupDestination, message);
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Found " + matches.size() + " methods: " + matches));
        }
        for (Match match : matches) {
            this.handleMatch(match.mapping, match.handlerMethod, lookupDestination, message);
        }
    }

    private void addMatchesToCollection(Collection<WampMessageMappingInfo> mappingsToCheck, Message<?> message, List<Match> matches) {
        for (WampMessageMappingInfo mapping : mappingsToCheck) {
            Object match = mapping.getMatchingCondition((Message)message);
            if (match == null) continue;
            List methods = (List)this.handlerMethods.get((Object)mapping);
            for (WampHandlerMethod method : methods) {
                matches.add(new Match((WampMessageMappingInfo)match, method));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMatch(WampMessageMappingInfo mapping, WampHandlerMethod handlerMethod, String lookupDestination, WampMessage message) {
        String matchedPattern;
        Map vars;
        if (!"**".equals(message.getDestination()) && !CollectionUtils.isEmpty((Map)(vars = this.pathMatcher.extractUriTemplateVariables(matchedPattern = mapping.getDestinationConditions().getPatterns().iterator().next(), lookupDestination)))) {
            message.setDestinationTemplateVariables(vars);
        }
        try {
            WampSessionContextHolder.setAttributesFromMessage(message);
            this.handleMatchInternal(handlerMethod, message);
        }
        finally {
            WampSessionContextHolder.resetAttributes();
        }
    }

    private void handleNoMatch(Set<WampMessageMappingInfo> ts, String lookupDestination, Message<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No matching methods.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static class Match {
        final WampMessageMappingInfo mapping;
        final WampHandlerMethod handlerMethod;

        private Match(WampMessageMappingInfo mapping, WampHandlerMethod handlerMethod) {
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }
}

