/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.method;

import ch.rasc.wampspring.method.DestinationPatternsMessageCondition;
import ch.rasc.wampspring.method.WampMessageTypeMessageCondition;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.MessageCondition;

public class WampMessageMappingInfo
implements MessageCondition<WampMessageMappingInfo> {
    private final WampMessageTypeMessageCondition messageTypeMessageCondition;
    private final DestinationPatternsMessageCondition destinationConditions;

    public WampMessageMappingInfo(WampMessageTypeMessageCondition messageTypeMessageCondition, DestinationPatternsMessageCondition destinationConditions) {
        this.messageTypeMessageCondition = messageTypeMessageCondition;
        this.destinationConditions = destinationConditions;
    }

    public WampMessageTypeMessageCondition getMessageTypeMessageCondition() {
        return this.messageTypeMessageCondition;
    }

    public DestinationPatternsMessageCondition getDestinationConditions() {
        return this.destinationConditions;
    }

    public WampMessageMappingInfo combine(WampMessageMappingInfo other) {
        WampMessageTypeMessageCondition typeCond = this.getMessageTypeMessageCondition().combine(other.getMessageTypeMessageCondition());
        DestinationPatternsMessageCondition destCond = this.destinationConditions.combine(other.getDestinationConditions());
        return new WampMessageMappingInfo(typeCond, destCond);
    }

    public WampMessageMappingInfo getMatchingCondition(Message<?> message) {
        WampMessageTypeMessageCondition typeCond = this.messageTypeMessageCondition.getMatchingCondition(message);
        if (typeCond == null) {
            return null;
        }
        DestinationPatternsMessageCondition destCond = this.destinationConditions.getMatchingCondition(message);
        if (destCond == null) {
            return null;
        }
        return new WampMessageMappingInfo(typeCond, destCond);
    }

    public int compareTo(WampMessageMappingInfo other, Message<?> message) {
        int result = this.messageTypeMessageCondition.compareTo(other.messageTypeMessageCondition, message);
        if (result != 0) {
            return result;
        }
        result = this.destinationConditions.compareTo(other.destinationConditions, message);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof WampMessageMappingInfo) {
            WampMessageMappingInfo other = (WampMessageMappingInfo)obj;
            return this.destinationConditions.equals((Object)other.destinationConditions) && this.messageTypeMessageCondition.equals((Object)other.messageTypeMessageCondition);
        }
        return false;
    }

    public int hashCode() {
        return this.destinationConditions.hashCode() * 31 + this.messageTypeMessageCondition.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append((Object)this.destinationConditions);
        builder.append(",messageType=").append((Object)this.messageTypeMessageCondition);
        builder.append('}');
        return builder.toString();
    }
}

