/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wampspring.user;

import java.security.Principal;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.messaging.SessionConnectedEvent;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

public final class UserSessionWebSocketHandlerDecoratorFactory
implements WebSocketHandlerDecoratorFactory {
    private final ApplicationEventPublisher eventPublisher;

    public UserSessionWebSocketHandlerDecoratorFactory(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"' eventPublisher' is required ");
        this.eventPublisher = eventPublisher;
    }

    public WebSocketHandler decorate(WebSocketHandler handler) {
        return new UserSessionWebSocketHandler(handler);
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            LogFactory.getLog(this.getClass()).error((Object)("Error publishing " + event), ex);
        }
    }

    private final class UserSessionWebSocketHandler
    extends WebSocketHandlerDecorator {
        public UserSessionWebSocketHandler(WebSocketHandler delegate) {
            super(delegate);
        }

        public void afterConnectionEstablished(WebSocketSession webSocketSession) throws Exception {
            super.afterConnectionEstablished(webSocketSession);
            Principal principal = webSocketSession.getPrincipal();
            if (principal != null) {
                SimpMessageHeaderAccessor accessor = SimpMessageHeaderAccessor.create((SimpMessageType)SimpMessageType.MESSAGE);
                accessor.setSessionId(webSocketSession.getId());
                UserSessionWebSocketHandlerDecoratorFactory.this.publishEvent((ApplicationEvent)new SessionConnectedEvent((Object)this, MessageBuilder.createMessage((Object)new byte[0], (MessageHeaders)accessor.getMessageHeaders()), principal));
            }
        }

        public void afterConnectionClosed(WebSocketSession webSocketSession, CloseStatus closeStatus) throws Exception {
            Principal principal = webSocketSession.getPrincipal();
            if (principal != null) {
                SimpMessageHeaderAccessor accessor = SimpMessageHeaderAccessor.create((SimpMessageType)SimpMessageType.MESSAGE);
                accessor.setSessionId(webSocketSession.getId());
                UserSessionWebSocketHandlerDecoratorFactory.this.publishEvent((ApplicationEvent)new SessionDisconnectEvent((Object)this, MessageBuilder.createMessage((Object)new byte[0], (MessageHeaders)accessor.getMessageHeaders()), webSocketSession.getId(), closeStatus, principal));
            }
            super.afterConnectionClosed(webSocketSession, closeStatus);
        }
    }
}

