/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.xodusqueue;

import ch.rasc.xodusqueue.serializer.BigDecimalXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.BigIntegerXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.BooleanXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.ByteXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.DefaultXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.DoubleXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.FloatXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.IntegerXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.LongXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.ShortXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.StringXodusQueueSerializer;
import ch.rasc.xodusqueue.serializer.XodusQueueSerializer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalComputable;
import jetbrains.exodus.log.LogConfig;

public class XodusQueue<T>
extends AbstractQueue<T>
implements AutoCloseable {
    private static final String STORE_NAME = "queue";
    private final Environment env;
    private final XodusQueueSerializer<T> serializer;

    public XodusQueue(String databaseDir, Class<T> entryClass) {
        this.env = Environments.newInstance((String)databaseDir);
        this.serializer = entryClass == String.class ? new StringXodusQueueSerializer() : (entryClass == Integer.class ? new IntegerXodusQueueSerializer() : (entryClass == Long.class ? new LongXodusQueueSerializer() : (entryClass == Boolean.class ? new BooleanXodusQueueSerializer() : (entryClass == Byte.class ? new ByteXodusQueueSerializer() : (entryClass == Double.class ? new DoubleXodusQueueSerializer() : (entryClass == Float.class ? new FloatXodusQueueSerializer() : (entryClass == Short.class ? new ShortXodusQueueSerializer() : (entryClass == BigInteger.class ? new BigIntegerXodusQueueSerializer() : (entryClass == BigDecimal.class ? new BigDecimalXodusQueueSerializer() : new DefaultXodusQueueSerializer<T>(entryClass))))))))));
    }

    public XodusQueue(String databaseDir, XodusQueueSerializer<T> serializer) {
        this.env = Environments.newInstance((String)databaseDir);
        this.serializer = serializer;
    }

    public XodusQueue(LogConfig logConfig, EnvironmentConfig environmentConfig, XodusQueueSerializer<T> serializer) {
        this.env = Environments.newInstance((LogConfig)logConfig, (EnvironmentConfig)environmentConfig);
        this.serializer = serializer;
    }

    @Override
    public boolean offer(T e) {
        Objects.requireNonNull(e);
        this.env.executeInExclusiveTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn);
            store.putRight(txn, (ByteIterable)LongBinding.longToEntry((long)(store.count(txn) + 1L)), this.serializer.toEntry(e));
        });
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        return (Boolean)this.env.computeInExclusiveTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn);
            long key = store.count(txn);
            boolean modified = false;
            for (Object e : c) {
                store.putRight(txn, (ByteIterable)LongBinding.longToEntry((long)(++key)), this.serializer.toEntry(e));
                modified = true;
            }
            return modified;
        });
    }

    @Override
    public T poll() {
        return this.pollInternal(true);
    }

    @Override
    public T peek() {
        return this.pollInternal(false);
    }

    private T pollInternal(boolean remove) {
        if (remove) {
            return (T)this.env.computeInExclusiveTransaction(this.pollComputable(true));
        }
        return (T)this.env.computeInReadonlyTransaction(this.pollComputable(false));
    }

    private TransactionalComputable<T> pollComputable(boolean remove) {
        return txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            if (store != null) {
                try (Cursor cursor = store.openCursor(txn);){
                    if (cursor.getNext()) {
                        ByteIterable value = cursor.getValue();
                        if (remove) {
                            cursor.deleteCurrent();
                        }
                        T t = this.serializer.fromEntry(value);
                        return t;
                    }
                }
            }
            return null;
        };
    }

    @Override
    public int size() {
        return (int)this.sizeLong();
    }

    public long sizeLong() {
        return (Long)this.env.computeInReadonlyTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            if (store != null) {
                return store.count(txn);
            }
            return 0L;
        });
    }

    @Override
    public void close() {
        if (this.env != null) {
            this.env.close();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.sizeLong() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        return (Boolean)this.env.computeInReadonlyTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            if (store != null) {
                return this.containsInternal(o, txn, store);
            }
            return false;
        });
    }

    private boolean containsInternal(Object o, Transaction txn, Store store) {
        try (Cursor cursor = store.openCursor(txn);){
            while (cursor.getNext()) {
                T e = this.serializer.fromEntry(cursor.getValue());
                if (!e.equals(o)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.env.computeInReadonlyTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            if (store != null) {
                Object[] r = new Object[(int)store.count(txn)];
                int ix = 0;
                try (Cursor cursor = store.openCursor(txn);){
                    while (cursor.getNext()) {
                        ByteIterable value = cursor.getValue();
                        T e = this.serializer.fromEntry(value);
                        r[ix++] = e;
                    }
                }
                return r;
            }
            return new Object[0];
        });
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return (Object[])this.env.computeInReadonlyTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            if (store != null) {
                int size = (int)store.count(txn);
                Object[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                int ix = 0;
                try (Cursor cursor = store.openCursor(txn);){
                    while (cursor.getNext()) {
                        ByteIterable value = cursor.getValue();
                        r[ix++] = this.serializer.fromEntry(value);
                    }
                }
                return r;
            }
            return a;
        });
    }

    @Override
    public boolean remove(Object o) {
        return (Boolean)this.env.computeInExclusiveTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            if (store != null) {
                try (Cursor cursor = store.openCursor(txn);){
                    while (cursor.getNext()) {
                        T e = this.serializer.fromEntry(cursor.getValue());
                        if (!o.equals(e)) continue;
                        cursor.deleteCurrent();
                        Boolean bl = true;
                        return bl;
                    }
                }
            }
            return false;
        });
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return (Boolean)this.env.computeInReadonlyTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            if (store != null) {
                for (Object e : c) {
                    if (this.containsInternal(e, txn, store)) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return (Boolean)this.env.computeInExclusiveTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            boolean modified = false;
            if (store != null) {
                try (Cursor cursor = store.openCursor(txn);){
                    while (cursor.getNext()) {
                        T e = this.serializer.fromEntry(cursor.getValue());
                        if (!c.contains(e)) continue;
                        cursor.deleteCurrent();
                        modified = true;
                    }
                }
            }
            return modified;
        });
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return (Boolean)this.env.computeInExclusiveTransaction(txn -> {
            Store store = this.env.openStore(STORE_NAME, StoreConfig.WITHOUT_DUPLICATES, txn, false);
            boolean modified = false;
            if (store != null) {
                try (Cursor cursor = store.openCursor(txn);){
                    while (cursor.getNext()) {
                        T e = this.serializer.fromEntry(cursor.getValue());
                        if (c.contains(e)) continue;
                        cursor.deleteCurrent();
                        modified = true;
                    }
                }
            }
            return modified;
        });
    }

    @Override
    public void clear() {
        this.env.executeInExclusiveTransaction(txn -> this.env.truncateStore(STORE_NAME, txn));
    }
}

