/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.xodusqueue.serializer;

import ch.rasc.xodusqueue.serializer.XodusQueueSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;

public class BigDecimalXodusQueueSerializer
implements XodusQueueSerializer<BigDecimal> {
    @Override
    public BigDecimal fromEntry(ByteIterable value) {
        ByteIterator bi = value.iterator();
        int scale = IntegerBinding.readCompressed((ByteIterator)bi);
        ArrayByteIterable unscaledValueByteArray = new ArrayByteIterable(bi);
        BigInteger unscaledValue = new BigInteger(Arrays.copyOf(unscaledValueByteArray.getBytesUnsafe(), unscaledValueByteArray.getLength()));
        return new BigDecimal(unscaledValue, scale);
    }

    @Override
    public ByteIterable toEntry(BigDecimal element) {
        return new CompoundByteIterable(new ByteIterable[]{IntegerBinding.intToCompressedEntry((int)element.scale()), new ArrayByteIterable(element.unscaledValue().toByteArray())});
    }
}

