/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.xodusqueue.serializer;

import ch.rasc.xodusqueue.serializer.XodusQueueSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;

public class DefaultXodusQueueSerializer<T>
implements XodusQueueSerializer<T> {
    private final KryoPool kryoPool;
    final Class<T> entryClass;

    public DefaultXodusQueueSerializer(Class<T> entryClass) {
        KryoFactory factory = () -> {
            Kryo kryo = new Kryo();
            kryo.register(entryClass);
            return kryo;
        };
        this.kryoPool = new KryoPool.Builder(factory).build();
        this.entryClass = entryClass;
    }

    @Override
    public T fromEntry(ByteIterable value) {
        ArrayByteIterable abi = new ArrayByteIterable(value);
        try (Input input = new Input(abi.getBytesUnsafe(), 0, abi.getLength());){
            Object object = this.kryoPool.run(kryo -> kryo.readObject(input, this.entryClass));
            return (T)object;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ByteIterable toEntry(T element) {
        Kryo kryo = this.kryoPool.borrow();
        try {
            try (Output output = new Output(64, -1);){
                kryo.writeObject(output, element);
                ArrayByteIterable arrayByteIterable = new ArrayByteIterable(output.toBytes());
                return arrayByteIterable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.kryoPool.release(kryo);
        }
    }
}

