/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.xodusqueue;

import ch.rasc.xodusqueue.XodusQueue;
import ch.rasc.xodusqueue.serializer.XodusQueueSerializer;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.log.LogConfig;

public class XodusBlockingQueue<T>
extends XodusQueue<T>
implements BlockingQueue<T> {
    private ReentrantLock reentrantLock;
    private Condition notEmpty;
    private Condition notFull;
    private long capacity;

    public XodusBlockingQueue(LogConfig logConfig, EnvironmentConfig environmentConfig, XodusQueueSerializer<T> serializer, long capacity) {
        super(logConfig, environmentConfig, serializer);
        this.initLocks(capacity, false);
    }

    public XodusBlockingQueue(String databaseDir, Class<T> entryClass, long capacity) {
        super(databaseDir, entryClass);
        this.initLocks(capacity, false);
    }

    public XodusBlockingQueue(String databaseDir, XodusQueueSerializer<T> serializer, long capacity) {
        super(databaseDir, serializer);
        this.initLocks(capacity, false);
    }

    public XodusBlockingQueue(LogConfig logConfig, EnvironmentConfig environmentConfig, XodusQueueSerializer<T> serializer, long capacity, boolean fair) {
        super(logConfig, environmentConfig, serializer);
        this.initLocks(capacity, fair);
    }

    public XodusBlockingQueue(String databaseDir, Class<T> entryClass, long capacity, boolean fair) {
        super(databaseDir, entryClass);
        this.initLocks(capacity, fair);
    }

    public XodusBlockingQueue(String databaseDir, XodusQueueSerializer<T> serializer, long capacity, boolean fair) {
        super(databaseDir, serializer);
        this.initLocks(capacity, fair);
    }

    private void initLocks(long capacity, boolean fair) {
        this.capacity = capacity;
        this.reentrantLock = new ReentrantLock(fair);
        this.notEmpty = this.reentrantLock.newCondition();
        this.notFull = this.reentrantLock.newCondition();
    }

    @Override
    public void put(T e) throws InterruptedException {
        Objects.requireNonNull(e);
        ReentrantLock lock = this.reentrantLock;
        lock.lockInterruptibly();
        try {
            while (super.sizeLong() >= this.capacity) {
                this.notFull.await();
            }
            super.offer(e);
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(e);
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.reentrantLock;
        lock.lockInterruptibly();
        try {
            while (super.sizeLong() >= this.capacity) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            super.offer(e);
            this.notEmpty.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T e) {
        Objects.requireNonNull(e);
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            if (super.sizeLong() >= this.capacity) {
                boolean bl = false;
                return bl;
            }
            boolean result = super.offer(e);
            this.notEmpty.signal();
            boolean bl = result;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        boolean modified = false;
        for (T e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            Object e = super.poll();
            this.notFull.signal();
            Object t = e;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public T take() throws InterruptedException {
        ReentrantLock lock = this.reentrantLock;
        lock.lockInterruptibly();
        try {
            while (super.sizeLong() == 0L) {
                this.notEmpty.await();
            }
            T t = this.poll();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.reentrantLock;
        lock.lockInterruptibly();
        try {
            while (super.sizeLong() == 0L) {
                if (nanos <= 0L) {
                    T t = null;
                    return t;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            T t = this.poll();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            long remaining = this.capacity - super.sizeLong();
            int n = remaining > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)remaining;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            int n;
            for (int i = n = super.drainTo(c, maxElements); i > 0 && lock.hasWaiters(this.notFull); --i) {
                this.notFull.signal();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            super.clear();
            for (long k = super.sizeLong(); k > 0L && lock.hasWaiters(this.notFull); --k) {
                this.notFull.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            boolean removed = super.remove(o);
            if (removed) {
                this.notFull.signal();
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            long sizeBefore = super.sizeLong();
            boolean removed = super.removeAll(c);
            if (removed) {
                long sizeAfter = super.sizeLong();
                for (long i = sizeBefore - sizeAfter; i > 0L && lock.hasWaiters(this.notFull); --i) {
                    this.notFull.signal();
                }
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        ReentrantLock lock = this.reentrantLock;
        lock.lock();
        try {
            long sizeBefore = super.sizeLong();
            boolean changed = super.retainAll(c);
            if (changed) {
                long sizeAfter = super.sizeLong();
                for (long i = sizeBefore - sizeAfter; i > 0L && lock.hasWaiters(this.notFull); --i) {
                    this.notFull.signal();
                }
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

