/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.xodusqueue.serializer;

import ch.rasc.xodusqueue.serializer.XodusQueueSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;

public class DefaultXodusQueueSerializer<T>
implements XodusQueueSerializer<T> {
    private final Pool<Kryo> kryoPool;
    final Class<T> entryClass;

    public DefaultXodusQueueSerializer(final Class<T> entryClass) {
        this.kryoPool = new Pool<Kryo>(true, false, 8){

            protected Kryo create() {
                Kryo kryo = new Kryo();
                kryo.register(entryClass);
                return kryo;
            }
        };
        this.entryClass = entryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T fromEntry(ByteIterable value) {
        ArrayByteIterable abi = new ArrayByteIterable(value);
        try (Input input = new Input(abi.getBytesUnsafe(), 0, abi.getLength());){
            Object object;
            Kryo kryo = (Kryo)this.kryoPool.obtain();
            try {
                object = kryo.readObject(input, this.entryClass);
            }
            catch (Throwable throwable) {
                this.kryoPool.free((Object)kryo);
                throw throwable;
            }
            this.kryoPool.free((Object)kryo);
            return (T)object;
        }
    }

    @Override
    public ByteIterable toEntry(T element) {
        Kryo kryo = (Kryo)this.kryoPool.obtain();
        try {
            ArrayByteIterable arrayByteIterable;
            try (Output output = new Output(64, -1);){
                kryo.writeObject(output, element);
                arrayByteIterable = new ArrayByteIterable(output.toBytes());
            }
            return arrayByteIterable;
        }
        finally {
            this.kryoPool.free((Object)kryo);
        }
    }
}

