/*
 * Decompiled with CFR 0.152.
 */
package ch.repnik.quartzretry;

import ch.repnik.quartzretry.QuartzRetry;
import ch.repnik.quartzretry.QuartzRetryException;
import ch.repnik.quartzretry.RetryContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
class RetryJob
implements Job {
    private final ApplicationContext ctx;

    @Autowired
    public RetryJob(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void execute(JobExecutionContext jobExecutionContext) {
        JobDataMap map = jobExecutionContext.getMergedJobDataMap();
        String className = map.get((Object)"classname").toString();
        int retryCount = (Integer)map.get((Object)"retryCount");
        byte[] payload = (byte[])map.get((Object)"payload");
        byte[] serializedRetryContext = (byte[])map.get((Object)"retryContext");
        Serializable deserialized = (Serializable)this.deserialize(payload);
        RetryContext retryContext = (RetryContext)this.deserialize(serializedRetryContext);
        try {
            QuartzRetry bean = (QuartzRetry)this.ctx.getBean(className);
            bean.setRetryCount(++retryCount);
            bean.execute(deserialized, retryContext);
        }
        catch (Exception e) {
            throw new QuartzRetryException("Could not create bean " + className, e);
        }
    }

    protected Object deserialize(byte[] in) {
        Object o;
        if (in == null) {
            return null;
        }
        try (ByteArrayInputStream bis = new ByteArrayInputStream(in);
             ConfigurableObjectInputStream is = new ConfigurableObjectInputStream((InputStream)bis, Thread.currentThread().getContextClassLoader());){
            o = is.readObject();
        }
        catch (Exception e) {
            throw new QuartzRetryException("Could not deserialize object from quartz jobDataMap", e);
        }
        return o;
    }
}

