/*
 * Decompiled with CFR 0.152.
 */
package ch.repnik.quartzretry;

import ch.repnik.quartzretry.QuartzRetryException;
import ch.repnik.quartzretry.RetryContext;
import ch.repnik.quartzretry.RetryJob;
import ch.repnik.quartzretry.RetryTimeout;
import java.io.Serializable;
import java.util.UUID;
import javax.sql.DataSource;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.SerializationUtils;

public abstract class QuartzRetry<P extends Serializable, R> {
    private Scheduler scheduler;
    private int retryCount = 0;
    private String classname;
    private boolean isRetryDisabled;
    private boolean isDatasourceBeanAvailable;
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzRetry.class);

    protected abstract R process(P var1, RetryContext var2);

    protected abstract RetryTimeout[] getRetryTimeouts();

    protected abstract void onError(P var1, Exception var2, RetryContext var3);

    protected abstract void onSuccess(P var1, R var2, RetryContext var3);

    protected abstract void onFailure(P var1, Exception var2, RetryContext var3);

    void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    void setClassname(String classname) {
        this.classname = classname;
    }

    @Autowired
    public final void setApplicationContext(ApplicationContext appCtx) {
        this.isRetryDisabled = Boolean.TRUE.equals(appCtx.getEnvironment().getProperty("quartz.retry.disabled", Boolean.class));
        if (this.isRetryDisabled) {
            LOGGER.warn("Spring Quartz Retry will not perform any retries because 'quartz.retry.disabled' property is set to 'false'");
        }
        try {
            appCtx.getBean(DataSource.class);
            this.isDatasourceBeanAvailable = true;
        }
        catch (NoSuchBeanDefinitionException e) {
            this.isDatasourceBeanAvailable = false;
            LOGGER.warn("Spring Quartz Retry will not perform any retries because there is no DataSource available");
        }
    }

    @Autowired
    public final void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    private void resetRetryCount() {
        this.retryCount = 0;
    }

    public void execute(P payload) {
        this.execute(payload, new RetryContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(P payload, RetryContext ctx) {
        ctx.setRetryCount(this.retryCount);
        try {
            R result = this.process(payload, ctx);
            this.onSuccess(payload, result, ctx);
            this.resetRetryCount();
        }
        catch (Exception e) {
            if (this.isRetryDisabled || !this.isDatasourceBeanAvailable || this.retryCount > this.getRetryTimeouts().length - 1) {
                this.onFailure(payload, e, ctx);
                this.resetRetryCount();
            }
            try {
                this.onError(payload, e, ctx);
            }
            finally {
                this.persistNewTrigger(payload, ctx);
            }
        }
    }

    private JobDetail job() {
        return JobBuilder.newJob(RetryJob.class).withIdentity("RetryJob", "RetryJobs").storeDurably().build();
    }

    private Trigger trigger(P payload, RetryContext ctx) {
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("payload", (Object)SerializationUtils.serialize(payload));
        dataMap.put("classname", this.classname != null ? this.classname : this.getClass().getName());
        dataMap.put("retryCount", this.retryCount);
        dataMap.put("retryContext", (Object)SerializationUtils.serialize((Object)ctx));
        RetryTimeout interval = this.getRetryTimeouts()[this.retryCount];
        return TriggerBuilder.newTrigger().forJob("RetryJob", "RetryJobs").startAt(DateBuilder.futureDate((int)interval.getNumber(), (DateBuilder.IntervalUnit)interval.getUnit())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0).withMisfireHandlingInstructionFireNow()).withIdentity(UUID.randomUUID().toString(), "RetryTriggers").usingJobData(dataMap).build();
    }

    private void persistNewTrigger(P payload, RetryContext ctx) {
        try {
            this.scheduler.addJob(this.job(), true);
            this.scheduler.scheduleJob(this.trigger(payload, ctx));
        }
        catch (SchedulerException ex) {
            throw new QuartzRetryException("Error while scheduling new quartz trigger for retry", ex);
        }
    }
}

