/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDSaveUtil;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.odi.IResultIterator;

class RDSave
implements IRDSave {
    private DataEngineContext context;
    private OutputStream rowExprsOs;
    private OutputStream rowLenOs;
    private int rowCount;
    private IBaseQueryDefinition queryDefn;
    private Set exprNameSet;
    private RowSaveUtil rowSaveUtil;
    private StreamManager streamManager;
    private RDSaveUtil rdSaveUtil;

    RDSave(DataEngineContext context, IBaseQueryDefinition queryDefn, int rowCount, QueryResultInfo queryResultInfo) throws DataException {
        this.context = context;
        this.rowCount = rowCount;
        this.queryDefn = queryDefn;
        this.streamManager = new StreamManager(context, queryResultInfo);
        this.rdSaveUtil = new RDSaveUtil(this.context, queryDefn, this.streamManager);
    }

    @Override
    public void saveExprValue(int currIndex, Map valueMap) throws DataException {
        if (this.rowSaveUtil == null) {
            this.initSaveRowUtil();
        }
        this.rowSaveUtil.saveExprValue(currIndex, valueMap);
    }

    private void initSaveRowUtil() throws DataException {
        this.rowExprsOs = this.streamManager.getOutStream(31, 0, 2);
        this.rowLenOs = this.streamManager.getOutStream(33, 0, 2);
        HashMap<String, String> bindingNameColumnName = new HashMap<String, String>();
        HashSet<String> bindingNamesToSave = new HashSet<String>();
        HashMap<String, Integer> bindingNameType = new HashMap<String, Integer>();
        Iterator it = this.queryDefn.getBindings().keySet().iterator();
        while (it.hasNext()) {
            String expression;
            String dataSetColumnName;
            IBaseExpression expr;
            String key = it.next().toString();
            IBinding binding = (IBinding)this.queryDefn.getBindings().get(key);
            if (this.streamManager.getVersion() >= 50 && this.queryDefn instanceof QueryDefinition && this.context.getMode() == 1 && binding.getAggregatOns().size() == 0 && binding.getAggrFunction() == null && (expr = binding.getExpression()) instanceof IScriptExpression && (dataSetColumnName = this.getDataSetColumnName(expression = ((IScriptExpression)expr).getText())) != null) {
                bindingNameColumnName.put(binding.getBindingName(), dataSetColumnName);
            }
            if (this.streamManager.getVersion() >= 110 && binding.getAggrFunction() != null) continue;
            if (bindingNameColumnName.get(binding.getBindingName()) == null || ((IQueryDefinition)this.queryDefn).isSummaryQuery()) {
                bindingNamesToSave.add(binding.getBindingName());
            }
            bindingNameType.put(binding.getBindingName(), binding.getDataType());
        }
        if (!(this.context.getMode() != 4 || this.queryDefn instanceof IQueryDefinition && ((IQueryDefinition)this.queryDefn).isSummaryQuery())) {
            bindingNamesToSave.add("_$$_dte_inner_row_id_$$_");
            bindingNameType.put("_$$_dte_inner_row_id_$$_", 2);
        }
        this.rowSaveUtil = new RowSaveUtil(this.rowCount, this.rowExprsOs, this.rowLenOs, bindingNamesToSave, bindingNameColumnName, bindingNameType, this.streamManager.getVersion());
    }

    private String getDataSetColumnName(String expr) {
        try {
            return ExpressionUtil.getColumnName(expr);
        }
        catch (BirtException e) {
            return null;
        }
    }

    @Override
    public void saveFinish(int currIndex) throws DataException {
        if (this.rowSaveUtil == null) {
            this.initSaveRowUtil();
        }
        this.exprNameSet = this.getExprNameSet();
        this.rowSaveUtil.saveFinish(currIndex);
        this.closeSaveRowUtil();
        this.saveForIV();
    }

    private void closeSaveRowUtil() throws DataException {
        try {
            this.rowExprsOs.close();
            this.rowLenOs.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, (Object)"Result Data");
        }
    }

    private void saveForIV() throws DataException {
        if (this.exprNameSet.size() == 0) {
            this.exprNameSet = this.getExprNameSet();
        }
        this.rdSaveUtil.saveExprMetadata(this.exprNameSet);
    }

    @Override
    public void saveResultIterator(IResultIterator odiResult, int groupLevel, int[] subQueryInfo) throws DataException {
        this.rdSaveUtil.saveResultIterator(odiResult, groupLevel, subQueryInfo);
    }

    private Set getExprNameSet() {
        HashSet set = new HashSet();
        for (Map.Entry entry : this.queryDefn.getBindings().entrySet()) {
            set.add(entry.getKey());
        }
        return set;
    }

    @Override
    public void saveStart() throws DataException {
        if (!this.streamManager.isSubquery()) {
            this.rdSaveUtil.saveQueryDefn();
        }
    }
}

