/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

import java.awt.Color;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.emitter.ppt.util.PPTUtil;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXCanvas;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXRender;
import org.eclipse.birt.report.engine.emitter.pptx.util.PPTXUtil;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.layout.emitter.BorderInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextLineArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class TextWriter {
    private final PPTXRender render;
    private final PPTXCanvas canvas;
    private final OOXmlWriter writer;
    private boolean needShape = true;
    private boolean needGroup = false;
    private boolean needDrawLineBorder = false;
    private boolean needDrawSquareBorder = false;
    private boolean firstTextInCell = true;
    private BorderInfo[] borders = null;
    private static String DEFAULT_HALIGNMENT = "l";
    private String hAlign = DEFAULT_HALIGNMENT;
    private final int MAX_VAL = 158400;
    private final String AUTOPAGENUMBER = "page-number";
    private final String TOTALPAGE = "total-page";
    private boolean hasParagraph = false;
    private PPTUtil.HyperlinkDef link = null;
    private boolean needClip = false;
    private String bmk_relationshipid = null;
    private String autotexttype = null;

    public TextWriter(PPTXRender render) {
        this.render = render;
        this.canvas = render.getCanvas();
        this.writer = this.canvas.getWriter();
    }

    public static boolean isSingleTextControl(IContainerArea container) {
        if (container instanceof BlockTextArea) {
            Iterator<IArea> iter = container.getChildren();
            while (iter.hasNext()) {
                IArea area = iter.next();
                if (area instanceof TextLineArea) continue;
                return false;
            }
            return TextWriter.hasNonEmptyTextArea(container);
        }
        if (container instanceof InlineTextArea) {
            Iterator<IArea> iter = container.getChildren();
            while (iter.hasNext()) {
                IArea area = iter.next();
                if (area instanceof TextArea) continue;
                return false;
            }
            return TextWriter.hasNonEmptyTextArea(container);
        }
        return false;
    }

    private static boolean hasNonEmptyTextArea(IArea container) {
        if (container instanceof TextArea) {
            return ((TextArea)container).getText() != null;
        }
        if (!(container instanceof IContainerArea)) {
            return false;
        }
        Iterator<IArea> iter = ((IContainerArea)container).getChildren();
        while (iter.hasNext()) {
            IArea area = iter.next();
            if (!TextWriter.hasNonEmptyTextArea(area)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSquareBorder(BorderInfo[] borders) {
        if (borders == null || borders.length != 4) {
            return false;
        }
        Color color = borders[0].borderColor;
        if (color == null) {
            return false;
        }
        int style = borders[0].borderStyle;
        int width = borders[0].borderWidth;
        if (width == 0) {
            return false;
        }
        int i = 1;
        while (i <= 3) {
            BorderInfo info = borders[i];
            if (!color.equals(info.borderColor) || info.borderStyle != style || info.borderWidth == 0 || info.borderWidth != width) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void writeTextBlock(int startX, int startY, int width, int height, ContainerArea container) {
        String bmk;
        IHyperlinkAction linkact = container.getAction();
        if (linkact != null && (bmk = linkact.getBookmark()) != null) {
            this.bmk_relationshipid = this.canvas.getPresentation().getBookmarkRelationshipid(bmk);
        }
        if ((bmk = container.getBookmark()) != null) {
            Presentation presentation = this.canvas.getPresentation();
            int currentslide = presentation.getCurrentSlideIdx();
            presentation.addBookmark(bmk, currentslide);
        }
        this.parseBlockTextArea(container);
        this.needClip = container.needClip();
        startX = PPTXUtil.convertToEnums(startX);
        startY = PPTXUtil.convertToEnums(startY);
        width = PPTXUtil.convertToEnums(width);
        height = PPTXUtil.convertToEnums(height);
        if (this.needGroup) {
            this.startGroup(startX, startY, width, height);
            startX = 0;
            startY = 0;
        }
        this.drawLineBorder(container);
        this.startBlockText(startX, startY, width, height, container);
        this.drawBlockTextChildren(container);
        this.endBlockText(container);
        if (this.needGroup) {
            this.endGroup();
        }
    }

    private void parseBlockTextArea(ContainerArea container) {
        if (container.getParent() instanceof CellArea && this.firstTextInCell) {
            this.needShape = false;
            return;
        }
        this.borders = this.render.cacheBorderInfo(container);
        if (this.borders != null) {
            if (TextWriter.isSquareBorder(this.borders)) {
                this.needDrawLineBorder = false;
                this.needDrawSquareBorder = true;
            } else {
                this.needGroup = true;
                this.needDrawLineBorder = true;
                this.needDrawSquareBorder = false;
            }
        }
    }

    private void drawLineBorder(ContainerArea container) {
        BorderInfo[] borders;
        if (!this.needDrawLineBorder) {
            return;
        }
        BorderInfo[] borderInfoArray = borders = this.render.cacheBorderInfo(container);
        int n = borders.length;
        int n2 = 0;
        while (n2 < n) {
            BorderInfo info = borderInfoArray[n2];
            info.endX -= info.startX;
            info.endY -= info.startY;
            info.startX = 0;
            info.startY = 0;
            ++n2;
        }
        this.render.drawBorder(borders);
    }

    private void startGroup(int startX, int startY, int width, int height) {
        int shapeId = this.canvas.getPresentation().getNextShapeId();
        this.writer.openTag("p:grpSp");
        this.writer.openTag("p:nvGrpSpPr");
        this.writer.openTag("p:cNvPr");
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "Group " + shapeId);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvGrpSpPr");
        this.writer.closeTag("p:cNvGrpSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvGrpSpPr");
        this.writer.openTag("p:grpSpPr");
        this.canvas.setPosition(startX, startY, width, height);
        this.writer.closeTag("p:grpSpPr");
    }

    private void endGroup() {
        this.writer.closeTag("p:grpSp");
    }

    private void drawBlockTextChildren(IArea child) {
        if (this.autotexttype != null) {
            this.writeAutoText((ContainerArea)child);
        } else if (child instanceof TextArea) {
            this.writeTextRun((TextArea)child);
        } else if (child instanceof TextLineArea || child instanceof InlineTextArea) {
            Iterator<IArea> iter = ((ContainerArea)child).getChildren();
            IArea grandchild = ((ContainerArea)child).getFirstChild();
            if (grandchild instanceof TextArea) {
                this.startTextLineArea(grandchild.getHeight() / 10, ((TextArea)grandchild).getStyle());
            }
            this.hasParagraph = true;
            while (iter.hasNext()) {
                IArea area = iter.next();
                this.drawBlockTextChildren(area);
            }
            IArea lastchild = ((ContainerArea)child).getLastChild();
            this.endTextLineArea((TextArea)lastchild);
            this.hasParagraph = false;
        } else if (child instanceof ContainerArea) {
            Iterator<IArea> iter = ((ContainerArea)child).getChildren();
            while (iter.hasNext()) {
                IArea area = iter.next();
                this.drawBlockTextChildren(area);
            }
        }
    }

    private void writeAutoText(ContainerArea container) {
        TextArea text = null;
        IArea child = container.getFirstChild();
        while (child != null && !(child instanceof TextArea)) {
            child = ((ContainerArea)child).getFirstChild();
        }
        if (child != null) {
            text = (TextArea)child;
        }
        if (text == null) {
            return;
        }
        if (this.autotexttype.equals("page-number")) {
            this.writer.openTag("a:p");
            this.writer.openTag("a:fld");
            this.writer.attribute("id", "{AE09BA1C-136E-4F28-AF64-63E231249911}");
            this.writer.attribute("type", "slidenum");
            this.setTextProperty("a:rPr", text.getStyle());
            this.writer.openTag("a:pPr");
            this.writer.closeTag("a:pPr");
            this.writer.openTag("a:t");
            this.canvas.writeText("\u2039#\u203a");
            this.writer.closeTag("a:t");
            this.writer.closeTag("a:fld");
            this.endTextLineArea(text);
        } else if (this.autotexttype.equals("total-page")) {
            Integer totalpage = this.canvas.getPresentation().getTotalSlides();
            text.setText(totalpage.toString());
            this.autotexttype = null;
            this.drawBlockTextChildren(container);
        } else {
            this.autotexttype = null;
            this.drawBlockTextChildren(container);
        }
    }

    private void startTextLineArea(int lineHeight, TextStyle style) {
        this.writer.openTag("a:p");
        this.writer.openTag("a:pPr");
        if (this.hAlign != null) {
            this.writer.attribute("algn", this.hAlign);
        }
        if (this.render.isRTL() || style.isRtl()) {
            this.writer.attribute("rtl", 1);
            if (this.hAlign == null) {
                this.writer.attribute("algn", "r");
            }
        }
        if (lineHeight > 0 && lineHeight < 158400) {
            this.writer.openTag("a:lnSpc");
            this.writer.openTag("a:spcPts");
            this.writer.attribute("val", this.canvas.getScaledValue(lineHeight));
            this.writer.closeTag("a:spcPts");
            this.writer.closeTag("a:lnSpc");
        }
        this.writer.closeTag("a:pPr");
    }

    private void endTextLineArea(TextArea area) {
        this.writeTextLineBreak(area.getStyle());
        this.writer.closeTag("a:p");
    }

    private void writeTextRun(TextArea text) {
        if (!this.hasParagraph) {
            this.startTextLineArea(text.getHeight() / 10, text.getStyle());
        }
        this.writer.openTag("a:r");
        this.setTextProperty("a:rPr", text.getStyle());
        this.writer.openTag("a:t");
        this.canvas.writeText(text.getText());
        this.writer.closeTag("a:t");
        this.writer.closeTag("a:r");
        if (!this.hasParagraph) {
            this.endTextLineArea(text);
        }
    }

    private void writeTextLineBreak(TextStyle style) {
        this.setTextProperty("a:endParaRPr", style);
    }

    private void setTextProperty(String tag, TextStyle style) {
        boolean isBold;
        FontInfo info = style.getFontInfo();
        this.writer.openTag(tag);
        this.writer.attribute("lang", "en-US");
        this.writer.attribute("altLang", "zh-CN");
        this.writer.attribute("dirty", "0");
        this.writer.attribute("smtClean", "0");
        if (style.isLinethrough()) {
            this.writer.attribute("strike", "sngStrike");
        }
        if (style.isUnderline()) {
            this.writer.attribute("u", "sng");
        }
        this.writer.attribute("sz", this.canvas.getScaledValue(info.getFontSize() * 100.0f));
        boolean isItalic = (info.getFontStyle() & 2) != 0;
        boolean bl = isBold = (info.getFontStyle() & 1) != 0;
        if (isItalic) {
            this.writer.attribute("i", 1);
        }
        if (isBold) {
            this.writer.attribute("b", 1);
        }
        this.canvas.setBackgroundColor(style.getColor());
        this.setTextFont(info.getFontName());
        this.canvas.setHyperlink(this.link);
        this.canvas.setBookmark(this.bmk_relationshipid);
        this.writer.closeTag(tag);
    }

    private void setTextFont(String fontName) {
        this.writer.openTag("a:latin");
        this.writer.attribute("typeface", fontName);
        this.writer.attribute("pitchFamily", "18");
        this.writer.attribute("charset", "0");
        this.writer.closeTag("a:latin");
        this.writer.openTag("a:ea");
        this.writer.attribute("typeface", fontName);
        this.writer.attribute("pitchFamily", "18");
        this.writer.attribute("charset", "0");
        this.writer.closeTag("a:ea");
        this.writer.openTag("a:cs");
        this.writer.attribute("typeface", fontName);
        this.writer.attribute("pitchFamily", "18");
        this.writer.attribute("charset", "0");
        this.writer.closeTag("a:cs");
    }

    private void writeLineStyle() {
        if (!this.needDrawSquareBorder) {
            return;
        }
        this.canvas.setProperty(this.borders[0].borderColor, PPTXUtil.convertToEnums(this.borders[0].borderWidth), this.borders[0].borderStyle);
    }

    private void startBlockText(int startX, int startY, int width, int height, ContainerArea container) {
        if (this.needShape) {
            this.writer.openTag("p:sp");
            this.writer.openTag("p:nvSpPr");
            this.writer.openTag("p:cNvPr");
            int shapeId = this.canvas.getPresentation().getNextShapeId();
            this.writer.attribute("id", shapeId);
            this.writer.attribute("name", "TextBox " + shapeId);
            this.canvas.setHyperlink(this.link);
            this.writer.closeTag("p:cNvPr");
            this.writer.openTag("p:cNvSpPr");
            this.writer.attribute("txBox", "1");
            this.writer.closeTag("p:cNvSpPr");
            this.writer.openTag("p:nvPr");
            this.writer.closeTag("p:nvPr");
            this.writer.closeTag("p:nvSpPr");
            this.writer.openTag("p:spPr");
            this.canvas.setPosition(startX, startY, width + 1, height);
            this.writer.openTag("a:prstGeom");
            this.writer.attribute("prst", "rect");
            this.writer.closeTag("a:prstGeom");
            BoxStyle style = container.getBoxStyle();
            Color color = style.getBackgroundColor();
            String imageRelationship = this.canvas.getImageRelationship(style.getBackgroundImage());
            if (imageRelationship != null) {
                this.canvas.setBackgroundImg(imageRelationship, 0, 0);
            } else if (color != null) {
                this.canvas.setBackgroundColor(color);
            } else {
                this.writer.openTag("a:noFill");
                this.writer.closeTag("a:noFill");
            }
            this.writeLineStyle();
            this.writer.closeTag("p:spPr");
            if (this.needDrawSquareBorder) {
                this.writer.openTag("p:style");
                this.writer.openTag("a:lnRef");
                this.writer.attribute("idx", "2");
                this.writer.openTag("a:schemeClr");
                this.writer.attribute("val", "dk1");
                this.writer.closeTag("a:schemeClr");
                this.writer.closeTag("a:lnRef");
                this.writer.openTag("a:fillRef");
                this.writer.attribute("idx", "1");
                this.writer.openTag("a:schemeClr");
                this.writer.attribute("val", "lt1");
                this.writer.closeTag("a:schemeClr");
                this.writer.closeTag("a:fillRef");
                this.writer.openTag("a:effectRef");
                this.writer.attribute("idx", "0");
                this.writer.openTag("a:schemeClr");
                this.writer.attribute("val", "dk1");
                this.writer.closeTag("a:schemeClr");
                this.writer.closeTag("a:effectRef");
                this.writer.openTag("a:fontRef");
                this.writer.attribute("idx", "minor");
                this.writer.openTag("a:schemeClr");
                this.writer.attribute("val", "dk1");
                this.writer.closeTag("a:schemeClr");
                this.writer.closeTag("a:fontRef");
                this.writer.closeTag("p:style");
            }
            this.writer.openTag("p:txBody");
        } else {
            this.writer.openTag("a:txBody");
        }
        int leftPadding = 0;
        int rightPadding = 0;
        int topPadding = 0;
        int bottomPadding = 0;
        if (container instanceof BlockTextArea) {
            IArea lastChild;
            IArea firstChild = container.getFirstChild();
            IContent ic = container.getContent();
            if (ic instanceof AutoTextContent) {
                AutoTextItemDesign id = (AutoTextItemDesign)ic.getGenerateBy();
                this.autotexttype = id.getType();
            }
            if (firstChild != null) {
                leftPadding = PPTXUtil.convertToEnums(firstChild.getX());
                rightPadding = width - leftPadding - PPTXUtil.convertToEnums(firstChild.getWidth());
                if (rightPadding < 0) {
                    rightPadding = 0;
                }
                topPadding = PPTXUtil.convertToEnums(firstChild.getY());
            }
            if ((lastChild = container.getChild(container.getChildrenCount() - 1)) != null && (bottomPadding = height - PPTXUtil.convertToEnums(lastChild.getY()) - PPTXUtil.convertToEnums(lastChild.getHeight())) < 0) {
                bottomPadding = 0;
            }
        }
        this.writer.openTag("a:bodyPr");
        if (this.needClip || !this.render.isTextWrap()) {
            this.writer.attribute("vertOverflow", "clip");
            this.writer.attribute("wrap", "square");
        } else {
            this.writer.attribute("wrap", "none");
        }
        this.writer.attribute("lIns", leftPadding);
        this.writer.attribute("tIns", topPadding);
        this.writer.attribute("rIns", rightPadding);
        this.writer.attribute("bIns", bottomPadding);
        this.writer.attribute("rtlCol", "0");
        IContent content = container.getContent();
        String vAlign = null;
        if (content != null) {
            vAlign = content.getComputedStyle().getVerticalAlign();
            if (vAlign != null && this.needShape) {
                if (vAlign.equals("bottom")) {
                    this.writer.attribute("anchor", "b");
                } else if (vAlign.equals("middle")) {
                    this.writer.attribute("anchor", "ctr");
                }
            }
            this.hAlign = content.getComputedStyle().getTextAlign();
            if (this.hAlign != null) {
                this.hAlign = this.hAlign.equals("left") ? "l" : (this.hAlign.equals("right") ? "r" : (this.hAlign.equals("center") ? "ctr" : (this.hAlign.equals("justify") ? "just" : DEFAULT_HALIGNMENT)));
            }
        }
        this.writer.closeTag("a:bodyPr");
    }

    private void endBlockText(ContainerArea container) {
        if (this.needShape) {
            this.writer.closeTag("p:txBody");
            this.writer.closeTag("p:sp");
        } else {
            this.writer.closeTag("a:txBody");
        }
    }

    public void writeBlankTextBlock(int fontSize) {
        this.writer.openTag("a:txBody");
        this.writer.openTag("a:bodyPr");
        this.writer.closeTag("a:bodyPr");
        this.writer.openTag("a:p");
        this.writer.openTag("a:endParaRPr");
        this.writer.attribute("sz", fontSize);
        this.writer.closeTag("a:endParaRPr");
        this.writer.closeTag("a:p");
        this.writer.closeTag("a:txBody");
    }

    public void setNotFirstTextInCell() {
        this.firstTextInCell = false;
    }

    public void setLink(PPTUtil.HyperlinkDef link) {
        this.link = link;
    }

    public PPTUtil.HyperlinkDef getLink() {
        return this.link;
    }
}

