/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.DocEmitterImpl;
import org.eclipse.birt.report.engine.internal.content.wrap.TableContentWrapper;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;

public class DocEmitter
extends ContentEmitterAdapter {
    public static final int MAX_COLUMN = 63;
    public static final String WORD_MARGIN_PADDING_WRAPPED_TABLE = "WordEmitter.WrappedTableForMarginPadding";
    public static final String WORD_HEADER_FOOTER_WRAPPED_TABLE = "WordEmitter.WrappedTableHeaderFooter";
    public static final String WORD_MARGIN_PADDING_COMBINE = "WordEmitter.CombineMarginPadding";
    public static final String WORD_ADD_EMPTY_PARAGRAPH_FOR_ALL_CELLS = "WordEmitter.AddEmptyParagraphForAllCells";
    public static final String WORD_ADD_EMPTY_PARAGRAPH_FOR_LIST_CELL = "WordEmitter.AddEmptyParagraphForListCell";
    private static Logger logger = Logger.getLogger(DocEmitter.class.getName());
    protected AbstractEmitterImpl emitterImplement = null;
    protected ContentEmitterVisitor contentVisitor = new ContentEmitterVisitor(this);
    private int omitCellLayer = 0;
    private boolean isClipped = false;

    public DocEmitter() {
        this.createEmitterImplement();
    }

    protected void createEmitterImplement() {
        this.emitterImplement = new DocEmitterImpl(this.contentVisitor);
    }

    @Override
    public void initialize(IEmitterServices service) throws EngineException {
        this.emitterImplement.initialize(service);
    }

    @Override
    public String getOutputFormat() {
        return this.emitterImplement.getOutputFormat();
    }

    @Override
    public void startPage(IPageContent page) throws BirtException {
        try {
            this.emitterImplement.startPage(page);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void end(IReportContent report) throws BirtException {
        try {
            this.emitterImplement.end(report);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void endCell(ICellContent cell) {
        if (this.omitCellLayer != 0) {
            --this.omitCellLayer;
            if (this.omitCellLayer == 0) {
                this.isClipped = false;
            }
            return;
        }
        this.emitterImplement.endCell(cell);
    }

    @Override
    public void endContainer(IContainerContent container) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endContainer(container);
    }

    @Override
    public void startContainer(IContainerContent container) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startContainer(container);
    }

    @Override
    public void endContent(IContent content) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endContent(content);
    }

    @Override
    public void endGroup(IGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endGroup(group);
    }

    public void accountPageProp(IPageContent page) {
        this.emitterImplement.computePageProperties(page);
    }

    @Override
    public void endList(IListContent list) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endList(list);
    }

    @Override
    public void endListBand(IListBandContent listBand) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endListBand(listBand);
    }

    @Override
    public void endListGroup(IListGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endListGroup(group);
    }

    @Override
    public void endPage(IPageContent page) {
        this.emitterImplement.endPage(page);
    }

    @Override
    public void endRow(IRowContent row) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endRow(row);
    }

    @Override
    public void endTable(ITableContent table) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endTable(table);
    }

    @Override
    public void endTableBand(ITableBandContent band) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endTableBand(band);
    }

    @Override
    public void endTableGroup(ITableGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.endTableGroup(group);
    }

    @Override
    public void start(IReportContent report) {
        this.emitterImplement.start(report);
    }

    @Override
    public void startAutoText(IAutoTextContent autoText) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startAutoText(autoText);
    }

    @Override
    public void startCell(ICellContent cell) {
        if (this.isClipped) {
            ++this.omitCellLayer;
            return;
        }
        int colCount = cell.getColumn();
        if (colCount >= 63) {
            ++this.omitCellLayer;
            this.isClipped = true;
            return;
        }
        this.emitterImplement.startCell(cell);
    }

    @Override
    public void startContent(IContent content) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startContent(content);
    }

    @Override
    public void startData(IDataContent data) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startData(data);
    }

    @Override
    public void startForeign(IForeignContent foreign) throws BirtException {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startForeign(foreign);
    }

    @Override
    public void startGroup(IGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startGroup(group);
    }

    @Override
    public void startImage(IImageContent image) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startImage(image);
    }

    @Override
    public void startLabel(ILabelContent label) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startLabel(label);
    }

    @Override
    public void startList(IListContent list) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startList(list);
    }

    @Override
    public void startListBand(IListBandContent listBand) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startListBand(listBand);
    }

    @Override
    public void startListGroup(IListGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startListGroup(group);
    }

    @Override
    public void startRow(IRowContent row) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startRow(row);
    }

    @Override
    public void startTable(ITableContent table) {
        if (this.isClipped) {
            return;
        }
        int colCount = table.getColumnCount();
        if (colCount > 63) {
            table = this.getPartTable(table);
            logger.log(Level.WARNING, "There are too many columns in the table , just output the first 63 columns");
        }
        this.emitterImplement.startTable(table);
    }

    private ITableContent getPartTable(ITableContent table) {
        List columns = table.getColumns();
        columns = columns.subList(0, 63);
        TableContentWrapper content = new TableContentWrapper(table, columns);
        return content;
    }

    @Override
    public void startTableBand(ITableBandContent band) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startTableBand(band);
    }

    @Override
    public void startTableGroup(ITableGroupContent group) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startTableGroup(group);
    }

    @Override
    public void startText(ITextContent text) {
        if (this.isClipped) {
            return;
        }
        this.emitterImplement.startText(text);
    }
}

