/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class DimensionPropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(DimensionPropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.dimension";

    public DimensionPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    @Override
    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.validateInputString(module, element, defn, (String)value);
        }
        if (value instanceof DimensionValue) {
            if (!StringUtil.isBlank(((DimensionValue)value).getUnits())) {
                return value;
            }
            return new DimensionValue(((DimensionValue)value).getMeasure(), this.getDefaultUnit(module, defn));
        }
        if (value instanceof Integer) {
            return this.fromDouble(module, defn, ((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return this.fromDouble(module, defn, (Double)value);
        }
        if (value instanceof BigDecimal) {
            return this.fromDouble(module, defn, ((BigDecimal)value).doubleValue());
        }
        logger.log(Level.SEVERE, "invalid dimension value type:" + String.valueOf(value));
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 3);
    }

    private String getDefaultUnit(Module module, PropertyDefn defn) {
        String unit = defn.getDefaultUnit();
        if (!StringUtil.isBlank(unit)) {
            return unit;
        }
        if (module == null) {
            return "in";
        }
        unit = module.getUnits();
        if (!StringUtil.isBlank(unit)) {
            return unit;
        }
        if (module.getSession() != null) {
            return module.getSession().getUnits();
        }
        return "in";
    }

    private DimensionValue fromDouble(Module module, PropertyDefn defn, double value) {
        return new DimensionValue(value, this.getDefaultUnit(module, defn));
    }

    @Override
    public Object validateXml(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        DimensionValue dim = StringUtil.parse(tmpValue);
        if (dim == null) {
            return null;
        }
        this.validateUnits(module, defn, dim);
        if (!"".equalsIgnoreCase(dim.getUnits())) {
            return dim;
        }
        return new DimensionValue(dim.getMeasure(), this.getDefaultUnit(module, defn));
    }

    @Override
    public Object validateInputString(Module module, DesignElement element, PropertyDefn defn, String value) throws PropertyValueException {
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        DimensionValue dim = StringUtil.parseInput(value, locale);
        if (dim == null) {
            return null;
        }
        this.validateUnits(module, defn, dim);
        if (!"".equalsIgnoreCase(dim.getUnits())) {
            return dim;
        }
        dim = new DimensionValue(dim.getMeasure(), this.getDefaultUnit(module, defn));
        return dim;
    }

    @Override
    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        assert (value instanceof DimensionValue);
        return ((DimensionValue)value).toDisplayString();
    }

    private void validateUnits(Module module, PropertyDefn defn, DimensionValue value) throws PropertyValueException {
        assert (value != null);
        String unit = value.getUnits();
        if ("".equalsIgnoreCase(unit)) {
            unit = this.getDefaultUnit(module, defn);
        }
        IChoiceSet units = defn.getAllowedUnits();
        assert (units != null);
        if (!StringUtil.isBlank(unit) && !units.contains(unit)) {
            logger.log(Level.SEVERE, "unit:" + unit + " not allowed ");
            throw new PropertyValueException(null, defn, (Object)value, "Error.PropertyValueException.UNIT_NOT_ALLOWED");
        }
    }

    @Override
    public int getTypeCode() {
        return 3;
    }

    @Override
    public String getName() {
        return "dimension";
    }

    @Override
    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public double toDouble(Module module, Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        DimensionValue dim = (DimensionValue)value;
        if ("".equalsIgnoreCase(dim.getUnits())) {
            return dim.getMeasure();
        }
        try {
            return DimensionUtil.convertTo(dim.getMeasure(), dim.getUnits(), module.getSession().getUnits()).getMeasure();
        }
        catch (IllegalArgumentException e) {
            return 0.0;
        }
    }
}

