/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.util.SecurityUtil;

public class URIUtilImpl {
    public static final String FILE_SCHEMA = "file";
    public static final String JAR_SCHEMA = "jar";
    public static final String HTTP_SCHEMA = "http";
    public static final String HTTPS_SCHEMA = "https";
    public static final String FTP_SCHEMA = "ftp";
    public static final String MAIL_SCHEMA = "mailto";
    public static final String JAR_EXTENTION = ".jar";
    private static final String URL_SIGNATURE = "://";
    private static final String URI_SIGNATURE = ":/";
    private static final String BUNDLE_RESOURCE_SCHEMA = "bundleresource";
    private static final String BUNDLE_ENTRY_SCHEMA = "bundleentry";

    public static URL getURLPresentation(String filePath) {
        if (filePath == null) {
            return null;
        }
        URL url = null;
        int sigPos = filePath.indexOf(URL_SIGNATURE);
        if (sigPos != -1) {
            try {
                url = new URL(filePath);
            }
            catch (MalformedURLException e) {
                return URIUtilImpl.getDiskFileDirectory(filePath, false);
            }
            return url;
        }
        if (filePath.startsWith(FILE_SCHEMA) || filePath.startsWith(JAR_SCHEMA)) {
            URI uri = null;
            try {
                uri = new URI(URIUtilImpl.toUniversalFileFormat(filePath));
                if (uri != null) {
                    return uri.toURL();
                }
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return URIUtilImpl.getDiskFileDirectory(filePath, false);
    }

    public static String toUniversalFileFormat(String filePath) {
        if (StringUtil.isBlank(filePath) || filePath.indexOf(92) == -1) {
            return filePath;
        }
        return filePath.replace('\\', '/');
    }

    public static String getLocalPath(String uri) {
        if (uri == null) {
            return null;
        }
        URI objURI = null;
        try {
            objURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            return URIUtilImpl.getLocalFileOfFailedURI(uri);
        }
        if (objURI.getScheme() == null) {
            if (URIUtilImpl.isFileProtocol(uri)) {
                return uri;
            }
        } else {
            if (objURI.getScheme().equalsIgnoreCase(FILE_SCHEMA)) {
                return objURI.getSchemeSpecificPart();
            }
            if (objURI.getScheme().length() == 1 || objURI.getScheme().equalsIgnoreCase(JAR_SCHEMA)) {
                return uri;
            }
        }
        return null;
    }

    private static boolean isFileProtocol(String filePath) {
        try {
            URL fileUrl = new URL(filePath);
            return FILE_SCHEMA.equalsIgnoreCase(fileUrl.getProtocol());
        }
        catch (MalformedURLException fileUrl) {
            File file = new File(filePath);
            String schema = SecurityUtil.getFiletoURISchemaPart(file);
            if (schema == null) {
                return false;
            }
            return schema.equalsIgnoreCase(FILE_SCHEMA);
        }
    }

    private static String getLocalFileOfFailedURI(String uri) {
        if (!URIUtilImpl.isLocalFilePath(uri)) {
            URL objURI = null;
            try {
                objURI = new URL(uri);
                if (objURI.getProtocol().equalsIgnoreCase(FILE_SCHEMA)) {
                    return objURI.getAuthority() == null ? objURI.getPath() : objURI.getAuthority() + objURI.getPath();
                }
                if (objURI.getProtocol().equalsIgnoreCase(JAR_SCHEMA)) {
                    return uri;
                }
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL url = URIUtilImpl.getFileDirectory(uri, false);
        if (uri.startsWith(JAR_SCHEMA)) {
            return "jar:file:" + url.getPath();
        }
        try {
            if (uri.startsWith(FILE_SCHEMA)) {
                return url.toURI().getSchemeSpecificPart();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }

    private static boolean isLocalFilePath(String uri) {
        int index = (uri = uri.trim()).indexOf(58);
        if (index == 1 || index == 2 && uri.startsWith("/")) {
            return Character.isLetter(uri.charAt(index - 1));
        }
        return false;
    }

    public static URL getDirectory(String filePath) {
        if (filePath == null) {
            return null;
        }
        URL url = null;
        int sigPos = filePath.indexOf(URI_SIGNATURE);
        if (sigPos != -1) {
            try {
                url = new URL(filePath);
            }
            catch (MalformedURLException e) {
                return URIUtilImpl.getDiskFileDirectory(filePath, true);
            }
            String tmpProtocol = url.getProtocol();
            if (url != null && tmpProtocol != null && tmpProtocol.length() > 1) {
                return URIUtilImpl.getDirectoryByURL(url);
            }
            return URIUtilImpl.getDiskFileDirectory(filePath, true);
        }
        String lowerFilePath = filePath.toLowerCase();
        if (lowerFilePath.startsWith(FILE_SCHEMA)) {
            URI uri = null;
            try {
                uri = new URI(URIUtilImpl.toUniversalFileFormat(filePath));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uri != null) {
                return URIUtilImpl.getFileDirectory(uri.getSchemeSpecificPart(), true);
            }
        }
        String prefix = null;
        if (lowerFilePath.startsWith(JAR_SCHEMA)) {
            prefix = JAR_SCHEMA;
        }
        if (prefix != null) {
            URI uri = null;
            try {
                uri = new URI(URIUtilImpl.toUniversalFileFormat(filePath));
                if (uri != null) {
                    return new URL(prefix + ":" + URIUtilImpl.getDirectory(uri.getSchemeSpecificPart()).toExternalForm() + "/");
                }
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return URIUtilImpl.getDiskFileDirectory(filePath, true);
    }

    public static URL getDirectory(URL url) {
        if (url == null) {
            return null;
        }
        return URIUtilImpl.getDirectoryByURL(url);
    }

    private static URL getDirectoryByURL(URL url) {
        if (FILE_SCHEMA.equalsIgnoreCase(url.getProtocol()) || JAR_SCHEMA.equalsIgnoreCase(url.getProtocol())) {
            URI uri = null;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                return url;
            }
            if (FILE_SCHEMA.equalsIgnoreCase(uri.getScheme())) {
                return URIUtilImpl.getFileDirectory(uri.getSchemeSpecificPart(), true);
            }
            if (JAR_SCHEMA.equalsIgnoreCase(uri.getScheme()) && !uri.getSchemeSpecificPart().toLowerCase().startsWith(HTTP_SCHEMA)) {
                return URIUtilImpl.getJarDirectory(uri.getSchemeSpecificPart(), true);
            }
        }
        return URIUtilImpl.getNetDirectory(url);
    }

    private static URL getNetDirectory(URL uri) {
        URL filePath = uri;
        String path = filePath.getFile();
        int index = path.lastIndexOf(47);
        if (index != -1 && index != path.length() - 1) {
            path = path.substring(0, index + 1);
        }
        try {
            return new URL(filePath.getProtocol(), filePath.getHost(), filePath.getPort(), path);
        }
        catch (MalformedURLException malformedURLException) {
            assert (false);
            return null;
        }
    }

    private static URL getDiskFileDirectory(String filePath, boolean returnDirectory) {
        URL url = null;
        url = filePath.indexOf(JAR_EXTENTION) > -1 ? URIUtilImpl.getJarDirectory(filePath, returnDirectory) : URIUtilImpl.getFileDirectory(filePath, returnDirectory);
        return url;
    }

    private static URL getFileDirectory(String filePath, boolean returnDirectory) {
        File file = new File(filePath);
        file = SecurityUtil.getAbsoluteFile(file);
        if (returnDirectory) {
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        try {
            return SecurityUtil.fileToURI(SecurityUtil.getCanonicalFile(file)).toURL();
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
    }

    private static URL getJarDirectory(String filePath, boolean returnDirectory) {
        block5: {
            URL url;
            if (filePath.startsWith(JAR_SCHEMA)) {
                filePath = filePath.substring(4);
            }
            if (filePath.startsWith(FILE_SCHEMA)) {
                filePath = filePath.substring(5);
            }
            if ((url = URIUtilImpl.getFileDirectory(filePath, returnDirectory)) != null) {
                try {
                    return new URL("jar:file:" + url.getPath() + "/");
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        return null;
    }

    public static URI resolveAbsolutePath(String path) {
        try {
            URI uri = new URI(path);
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static boolean isBundleProtocol(String filePath) {
        if (filePath == null) {
            return false;
        }
        int sigPos = filePath.indexOf(URL_SIGNATURE);
        return sigPos != -1 && (filePath.startsWith(BUNDLE_RESOURCE_SCHEMA) || filePath.startsWith(BUNDLE_ENTRY_SCHEMA));
    }
}

