/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.TextAdapter;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Label;

public final class SwingTextMetrics
extends TextAdapter {
    private int iLineCount = 0;
    private Object oText = null;
    private Graphics2D g2d = null;
    private FontMetrics fm = null;
    private TextLayout[] tla = null;
    private String[] fsa = null;
    private double[] faWidth = null;
    private Label la = null;
    private final IDisplayServer xs;
    private Insets ins = null;
    private double cachedwidth;

    public SwingTextMetrics(IDisplayServer _xs, Label _la, Graphics2D _g2d) {
        this(_xs, _la, _g2d, true);
    }

    public SwingTextMetrics(IDisplayServer _xs, Label _la, Graphics2D _g2d, boolean autoReuse) {
        this.g2d = _g2d;
        this.xs = _xs;
        this.la = _la;
        this.computeTextAntialiasing();
        if (autoReuse) {
            this.reuse(this.la);
        }
    }

    private void computeTextAntialiasing() {
        FontDefinition font = this.la.getCaption().getFont();
        if (font.isBold() || font.getRotation() % 90.0 != 0.0 || font.getSize() > 13.0f) {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    @Override
    public void reuse(Label la, double forceWrappingSize) {
        String[] sa;
        Font f = (Font)this.xs.createFont(la.getCaption().getFont());
        this.fm = this.g2d.getFontMetrics(f);
        FontRenderContext frc = this.g2d.getFontRenderContext();
        this.cachedwidth = Double.NaN;
        String s = la.getCaption().getValue();
        s = s == null ? IConstants.NULL_STRING : s.trim();
        if (s.length() == 0) {
            s = " ";
        }
        if ((sa = this.splitOnBreaks(s, forceWrappingSize, f)) == null) {
            this.iLineCount = 1;
            this.oText = s;
            this.tla = new TextLayout[1];
            this.fsa = new String[1];
            this.tla[0] = new TextLayout(s, f.getAttributes(), frc);
            this.fsa[0] = s;
        } else {
            this.iLineCount = sa.length;
            this.oText = sa;
            this.tla = new TextLayout[this.iLineCount];
            this.fsa = new String[this.iLineCount];
            int i = 0;
            while (i < this.iLineCount) {
                this.tla[i] = new TextLayout(sa[i], f.getAttributes(), frc);
                this.fsa[i] = sa[i];
                ++i;
            }
        }
        this.ins = la.getInsets().scaledInstance(this.pointsToPixels());
        if (forceWrappingSize > 0.0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.fsa.length) {
                sb.append(this.fsa[i]).append("\n");
                ++i;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            la.getCaption().setValue(sb.toString());
        }
    }

    @Override
    public double getHeight() {
        return this.fm.getHeight();
    }

    @Override
    public double getDescent() {
        return this.fm.getDescent();
    }

    private double stringWidth() {
        if (!Double.isNaN(this.cachedwidth)) {
            return this.cachedwidth;
        }
        this.faWidth = new double[this.iLineCount];
        this.cachedwidth = 0.0;
        if (this.iLineCount > 1) {
            double dMaxWidth = 0.0;
            int i = 0;
            while (i < this.iLineCount) {
                Rectangle2D r2d = this.tla[i].getBounds();
                double dWidth = r2d.getWidth();
                this.faWidth[i] = Math.max(0.0, dWidth);
                if (dWidth > dMaxWidth) {
                    dMaxWidth = dWidth;
                }
                ++i;
            }
            this.cachedwidth = Math.max(0.0, dMaxWidth);
        } else if (this.iLineCount == 1) {
            double w = this.fm.getStringBounds(this.fsa[0], this.g2d).getWidth();
            this.faWidth[0] = this.cachedwidth = Math.max(0.0, w);
        }
        return this.cachedwidth;
    }

    double pointsToPixels() {
        return (double)this.xs.getDpiResolution() / 72.0;
    }

    @Override
    public double getFullHeight() {
        return this.getHeight() * (double)this.getLineCount() + (this.ins.getTop() + this.ins.getBottom());
    }

    @Override
    public double getFullHeight(double fontHeight) {
        return fontHeight * (double)this.getLineCount() + this.ins.getTop() + this.ins.getBottom();
    }

    @Override
    public double getFullWidth() {
        return this.stringWidth() + (this.ins.getLeft() + this.ins.getRight());
    }

    @Override
    public double getWidth(int iIndex) {
        if (this.faWidth == null) {
            this.stringWidth();
        }
        return this.faWidth[iIndex];
    }

    @Override
    public int getLineCount() {
        return this.iLineCount;
    }

    @Override
    public String getLine(int iIndex) {
        return this.iLineCount > 1 ? ((String[])this.oText)[iIndex] : (String)this.oText;
    }

    public TextLayout getLayout(int iIndex) {
        return this.iLineCount > 1 ? this.tla[iIndex] : this.tla[0];
    }

    private String[] splitOnBreaks(String s, double maxSize, Font ft) {
        int n;
        int j;
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        do {
            String ss;
            if ((j = s.indexOf(10, i)) == -1) {
                j = s.length();
            }
            if ((ss = s.substring(i, j)) != null && ss.length() > 0) {
                al.add(ss);
            }
            i = j + 1;
        } while (j != -1 && j < s.length());
        if (maxSize > 0.0) {
            ArrayList<String> nal = new ArrayList<String>();
            for (String ns : al) {
                AttributedString as = new AttributedString(ns, ft.getAttributes());
                LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), this.g2d.getFontRenderContext());
                while (lbm.getPosition() < ns.length()) {
                    int next = lbm.nextOffset((float)maxSize);
                    String ss = ns.substring(lbm.getPosition(), next);
                    lbm.setPosition(next);
                    nal.add(ss);
                }
            }
            al = nal;
        }
        if ((n = al.size()) == 1 || n == 0) {
            return null;
        }
        String[] sa = new String[n];
        i = 0;
        while (i < al.size()) {
            sa[i] = (String)al.get(i);
            ++i;
        }
        return sa;
    }

    @Override
    public void dispose() {
    }
}

