/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.examples.radar.render;

import java.util.ArrayList;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.examples.radar.model.type.RadarSeries;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public class RadarScaleHelper {
    private int scaleCount = 6;
    private double axisMin = Double.MAX_VALUE;
    private double axisMax = Double.MIN_VALUE;
    private boolean autoscale = false;
    private RadarSeries radarSeries;
    private ChartWithoutAxes chartWithoutAxes;

    public RadarScaleHelper(RadarSeries series, ChartWithoutAxes chartWithoutAxes) {
        this.radarSeries = series;
        this.chartWithoutAxes = chartWithoutAxes;
    }

    public void compute() throws ChartException {
        int psc = this.radarSeries.getPlotSteps().intValue();
        if (psc > 20) {
            psc = 20;
        }
        if (psc < 1) {
            psc = 1;
        }
        this.scaleCount = psc;
        this.computeDsMinMax();
    }

    public int getScaleCount() {
        return this.scaleCount;
    }

    public boolean getAutoScale() {
        return this.autoscale;
    }

    public double getAxisMin() {
        if (this.autoscale) {
            double nmin = this.axisMin - this.axisMin * (1.0 / (double)(this.scaleCount * 5));
            return nmin;
        }
        return this.axisMin;
    }

    public double getAxisMax() {
        if (this.autoscale) {
            double nmax = this.axisMax + this.axisMax * (1.0 / (double)(this.scaleCount * 5));
            return nmax;
        }
        return this.axisMax;
    }

    private void computeDsMinMax() throws ChartException {
        double calcMin = Double.MAX_VALUE;
        double calcMax = Double.MIN_VALUE;
        if (!this.radarSeries.isSetRadarAutoScale() || this.radarSeries.isRadarAutoScale()) {
            this.autoscale = true;
        } else {
            double taxisMin = this.radarSeries.getWebLabelMin();
            double taxisMax = this.radarSeries.getWebLabelMax();
            if (taxisMax - taxisMin == 0.0) {
                this.autoscale = true;
            }
        }
        PluginSettings ps = PluginSettings.instance();
        IDataSetProcessor iDSP = null;
        EList<SeriesDefinition> el = this.chartWithoutAxes.getSeriesDefinitions();
        ArrayList<Series> al = new ArrayList<Series>();
        ((ChartWithoutAxesImpl)this.chartWithoutAxes).recursivelyGetSeries(el, al, 0, 0);
        Series[] sea = al.toArray(new Series[al.size()]);
        int i = 0;
        while (i < sea.length) {
            Double max;
            iDSP = ps.getDataSetProcessor(sea[i].getClass());
            DataSet dst = sea[i].getDataSet();
            Object oMin = iDSP.getMinimum(dst);
            Object oMax = iDSP.getMaximum(dst);
            Double min = oMin == null ? null : Double.valueOf(((Number)oMin).doubleValue());
            Double d = max = oMax == null ? null : Double.valueOf(((Number)oMax).doubleValue());
            if (min != null && min < calcMin) {
                calcMin = min;
            }
            if (max != null && max > calcMax) {
                calcMax = max;
            }
            ++i;
        }
        if (this.autoscale) {
            this.axisMin = calcMin;
            this.axisMax = calcMax;
        } else {
            this.axisMin = this.radarSeries.getWebLabelMin();
            this.axisMax = this.radarSeries.getWebLabelMax();
        }
    }
}

