/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.IChartObject;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ChartElementUtil {
    public static int PROPERTY_UPDATE = 1;
    public static int PROPERTY_UNSET = 2;

    public static void setDefaultValue(Object obj, String fieldName, Object value) throws ChartException {
        AccessibleObject field = null;
        try {
            Class<?> cc = obj.getClass();
            boolean existence = false;
            while (!existence && cc != null) {
                try {
                    field = cc.getDeclaredField(fieldName);
                    existence = true;
                }
                catch (NoSuchFieldException e) {
                    cc = cc.getSuperclass();
                }
            }
            if (field == null) {
                return;
            }
            boolean accessible = field.isAccessible();
            if (!accessible) {
                ((Field)field).setAccessible(true);
                ((Field)field).set(obj, value);
                ((Field)field).setAccessible(accessible);
            } else {
                ((Field)field).set(obj, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new ChartException("org.eclipse.birt.chart.engine", 21, (Throwable)e);
        }
    }

    public static void setEObjectAttribute(EObject eContainer, String attribute, Object value, boolean isUnset) {
        EStructuralFeature esf = eContainer.eClass().getEStructuralFeature(attribute);
        if (esf == null) {
            return;
        }
        if (isUnset) {
            eContainer.eUnset(esf);
        } else {
            eContainer.eSet(esf, value);
        }
    }

    public static Object getEObjectAttributeValue(EObject eContainer, String attribute) {
        EStructuralFeature esf = eContainer.eClass().getEStructuralFeature(attribute);
        if (esf == null) {
            return null;
        }
        return eContainer.eGet(esf);
    }

    public static boolean isSetEObjectAttribute(EObject eContainer, String attribute) {
        EStructuralFeature esf = eContainer.eClass().getEStructuralFeature(attribute);
        if (esf == null) {
            return false;
        }
        return eContainer.eIsSet(esf);
    }

    public static boolean isSetSeriesPalette(Chart chart) {
        Palette p = ChartUtil.getCategorySeriesDefinition(chart).getSeriesPalette();
        return p != null && p.getEntries().size() > 0;
    }

    public static boolean isSetInsets(Insets insets) {
        return insets.isSetTop() && insets.isSetBottom() && insets.isSetLeft() && insets.isSetRight();
    }

    public static boolean isSetDataPointComponents(Series series) {
        return !series.getDataPoint().getComponents().isEmpty();
    }

    public static boolean isSetStringProperty(String s) {
        return s != null && !s.trim().equals("");
    }

    public static <T> List<T> copyInstance(List<T> objs) {
        ArrayList<IChartObject> lst = new ArrayList<IChartObject>();
        for (T o : objs) {
            if (o instanceof IChartObject) {
                lst.add(((IChartObject)o).copyInstance());
                continue;
            }
            lst.add((IChartObject)o);
        }
        return lst;
    }

    public static <T, J> Map<T, J> copyInstance(Map<T, J> objs) {
        HashMap<T, IChartObject> map = new HashMap<T, IChartObject>();
        for (Map.Entry<T, J> o : objs.entrySet()) {
            if (o.getValue() instanceof IChartObject) {
                map.put(o.getKey(), ((IChartObject)o.getValue()).copyInstance());
                continue;
            }
            map.put(o.getKey(), (IChartObject)o.getValue());
        }
        return map;
    }
}

