/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.LinkedList;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMovingAve
extends AggrFunction {
    @Override
    public String getName() {
        return "MOVINGAVE";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("window", Messages.getString("TotalMovingAve.param.window"), false, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalMovingAve.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalMovingAve.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private LinkedList list;
        private int window = 1;
        private Number sum = null;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() throws DataException {
            super.start();
            this.sum = null;
            this.list = new LinkedList();
            this.window = 1;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 1);
            if (args[0] != null && args[1] != null) {
                try {
                    if (this.list.size() == 0) {
                        this.window = DataTypeUtil.toInteger(args[1]);
                        assert (this.window > 0);
                    }
                    this.list.addLast(args[0]);
                    this.sum = this.calculator.add(this.sum, this.calculator.getTypedObject(args[0]));
                    if (this.list.size() > this.window) {
                        this.sum = this.calculator.subtract(this.sum, this.calculator.getTypedObject(this.list.get(0)));
                        this.list.remove(0);
                    }
                }
                catch (BirtException e) {
                    throw DataException.wrap(new AggrException("aggregation.DataConversionError", e));
                }
            }
        }

        @Override
        public Object getValue() throws DataException {
            if (this.list.size() == 0) {
                return null;
            }
            return this.calculator.divide(this.sum, this.calculator.getTypedObject(this.list.size()));
        }
    }
}

