/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.aggregation.impl.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalPercentSum
extends AggrFunction {
    @Override
    public String getName() {
        return "PERCENTSUM";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public int getNumberOfPasses() {
        return 2;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalPercentSum.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalPercentSum.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private Number sum = 0.0;
        private int passNo = 0;
        private Object value;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() throws DataException {
            super.start();
            ++this.passNo;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (this.passNo == 1) {
                if (args[0] != null) {
                    this.sum = this.calculator.add(this.sum, this.calculator.getTypedObject(args[0]));
                }
            } else if (args[0] != null) {
                Double d = RankAggregationUtil.getNumericValue(args[0]);
                this.value = this.sum.equals(0.0) || d == null ? (Number)new Integer(0) : (Number)this.calculator.divide(this.calculator.getTypedObject(args[0]), this.sum);
            } else {
                this.value = 0;
            }
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

