/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SizeOfUtil {
    private static int INTEGER_SIZE;
    private static int DOUBLE_SIZE;
    private static int BIGDECIMAL_SIZE;
    private static int DATE_SIZE;
    private static int TIME_SIZE;
    private static int SQL_DATE_SIZE;
    private static int TIMESTAMP_SIZE;
    private static int STRING_OVERHEAD;
    private static int STRING_SIZE;
    public static int POINTER_SIZE;
    public static int PRIMITIVE_ARRAY_OVERHEAD;
    public static int OBJECT_OVERHEAD;
    public static int OBJECT_ARRAY_OVERHEAD;
    private int fieldCount = 0;
    private boolean[] isfixedSize = null;
    private int[] fieldSize = null;

    static {
        String JVMBit;
        INTEGER_SIZE = 16;
        DOUBLE_SIZE = 16;
        BIGDECIMAL_SIZE = 200;
        DATE_SIZE = 24;
        TIME_SIZE = 24;
        SQL_DATE_SIZE = 24;
        TIMESTAMP_SIZE = 24;
        STRING_OVERHEAD = 40;
        STRING_SIZE = 80;
        POINTER_SIZE = 4;
        PRIMITIVE_ARRAY_OVERHEAD = 12;
        OBJECT_OVERHEAD = 8;
        OBJECT_ARRAY_OVERHEAD = 12;
        if (System.getProperty("java.version").startsWith("1.5")) {
            BIGDECIMAL_SIZE = 200;
            TIMESTAMP_SIZE = 32;
        }
        if ((JVMBit = System.getProperty("sun.arch.data.model")) != null) {
            try {
                if (DataTypeUtil.toInteger(JVMBit) == 64) {
                    INTEGER_SIZE = 24;
                    DOUBLE_SIZE = 24;
                    BIGDECIMAL_SIZE = 216;
                    DATE_SIZE = 32;
                    TIME_SIZE = 32;
                    SQL_DATE_SIZE = 32;
                    TIMESTAMP_SIZE = 32;
                    STRING_OVERHEAD = 56;
                    STRING_SIZE = 96;
                    POINTER_SIZE = 8;
                    PRIMITIVE_ARRAY_OVERHEAD = 20;
                    OBJECT_ARRAY_OVERHEAD = 24;
                }
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
    }

    public SizeOfUtil(IResultClass resultClass) throws DataException {
        this.fieldCount = resultClass.getFieldCount();
        this.isfixedSize = new boolean[resultClass.getFieldCount()];
        this.fieldSize = new int[resultClass.getFieldCount()];
        int i = 1;
        while (i <= resultClass.getFieldCount()) {
            if (SizeOfUtil.isFixedSizeClass(resultClass.getFieldValueClass(i))) {
                this.fieldSize[i - 1] = SizeOfUtil.sizeOf(resultClass.getFieldValueClass(i));
                this.isfixedSize[i - 1] = true;
            } else {
                this.isfixedSize[i - 1] = false;
            }
            ++i;
        }
    }

    private static boolean isFixedSizeClass(Class objectClass) {
        return objectClass.equals(Integer.class) || objectClass.equals(Double.class) || objectClass.equals(BigDecimal.class) || objectClass.equals(Date.class) || objectClass.equals(java.sql.Date.class) || objectClass.equals(Time.class) || objectClass.equals(Timestamp.class);
    }

    private static int sizeOf(Class objectClass) {
        if (objectClass.equals(Integer.class)) {
            return INTEGER_SIZE;
        }
        if (objectClass.equals(Double.class)) {
            return DOUBLE_SIZE;
        }
        if (objectClass.equals(BigDecimal.class)) {
            return BIGDECIMAL_SIZE;
        }
        if (objectClass.equals(Date.class)) {
            return DATE_SIZE;
        }
        if (objectClass.equals(Time.class)) {
            return TIME_SIZE;
        }
        if (objectClass.equals(Timestamp.class)) {
            return TIMESTAMP_SIZE;
        }
        if (objectClass.equals(java.sql.Date.class)) {
            return SQL_DATE_SIZE;
        }
        if (objectClass.equals(String.class)) {
            return STRING_SIZE;
        }
        return 0;
    }

    public int sizeOf(IResultObject resultObject) throws DataException {
        int returnValue = 0;
        int i = 1;
        while (i <= this.fieldCount) {
            if (!this.isfixedSize[i - 1]) {
                if (resultObject.getFieldValue(i) != null) {
                    returnValue += SizeOfUtil.sizeOf(resultObject.getFieldValue(i).getClass(), resultObject.getFieldValue(i));
                }
            } else if (resultObject.getFieldValue(i) != null) {
                returnValue += this.fieldSize[i - 1];
            }
            ++i;
        }
        int fieldsSize = POINTER_SIZE * 2 + 8 + (4 + this.fieldCount * 4 - 1) / 8 * 8;
        return returnValue += POINTER_SIZE * 2 + 8 + (4 + fieldsSize - 1) / 8 * 8;
    }

    public static int sizeOf(int dataType) {
        if (dataType == 2) {
            return INTEGER_SIZE;
        }
        if (dataType == 3) {
            return DOUBLE_SIZE;
        }
        if (dataType == 10) {
            return TIME_SIZE;
        }
        if (dataType == 6) {
            return TIMESTAMP_SIZE;
        }
        if (dataType == 9) {
            return SQL_DATE_SIZE;
        }
        if (dataType == 4) {
            return BIGDECIMAL_SIZE;
        }
        if (dataType == 5) {
            return STRING_SIZE;
        }
        return 0;
    }

    public static int getArraySize(int length) {
        if (length == 0) {
            return 0;
        }
        return POINTER_SIZE * 2 + 8 + (POINTER_SIZE + length * 4 - 1) / 8 * 8;
    }

    public static int getObjectSize(int[] dataType) {
        int size = 0;
        int i = 0;
        while (i < dataType.length) {
            size += SizeOfUtil.sizeOf(dataType[i]);
            ++i;
        }
        return size += SizeOfUtil.getArraySize(dataType.length);
    }

    public static int sizeOf(Class objectClass, Object object) {
        if (object == null) {
            return 0;
        }
        if (objectClass.equals(String.class)) {
            int strLen = ((String)object).length();
            return STRING_OVERHEAD + (strLen + 1) / 4 * 8;
        }
        if (objectClass.equals(byte[].class)) {
            int byteLen = ((byte[])object).length;
            return POINTER_SIZE * 2 + 8 + (4 + byteLen - 1) / 8 * 8;
        }
        return SizeOfUtil.sizeOf(objectClass);
    }
}

