/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.group.GroupCalculator;

class NumericGroupCalculator
extends GroupCalculator {
    double doubleStartValue;

    public NumericGroupCalculator(Object intervalStart, double intervalRange) throws BirtException {
        super(intervalStart, intervalRange);
        this.intervalRange = intervalRange = intervalRange == 0.0 ? 1.0 : intervalRange;
        this.doubleStartValue = intervalStart == null ? 0.0 : DataTypeUtil.toDouble(intervalStart);
    }

    @Override
    public Object calculate(Object value) throws BirtException {
        if (value == null) {
            return new Double(-1.0);
        }
        double dValue = DataTypeUtil.toDouble(value);
        if (dValue < this.doubleStartValue) {
            return new Double(-1.0);
        }
        return new Double(Math.floor((dValue - this.doubleStartValue) / this.intervalRange));
    }
}

