/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;

public class MultiKeySelection
implements ISelection {
    private Object[][] keyValues;
    private Object[] minKey = null;
    private Object[] maxKey = null;
    private static Logger logger = Logger.getLogger(MultiKeySelection.class.getName());

    public Object[][] getKeyValues() {
        return this.keyValues;
    }

    public MultiKeySelection(Object[][] keys) {
        logger.entering(MultiKeySelection.class.getName(), "MultiKeySelection", (Object[])keys);
        assert (keys != null && keys.length > 0);
        this.minKey = keys[0];
        this.maxKey = keys[0];
        int i = 1;
        while (i < keys.length) {
            if (CompareUtil.compare(keys[i], this.minKey) < 0) {
                this.minKey = keys[i];
            }
            if (CompareUtil.compare(keys[i], this.maxKey) > 0) {
                this.maxKey = keys[i];
            }
            ++i;
        }
        this.keyValues = keys;
        logger.exiting(MultiKeySelection.class.getName(), "MultiKeySelection");
    }

    @Override
    public Object[] getMax() {
        return this.maxKey;
    }

    @Override
    public Object[] getMin() {
        return this.minKey;
    }

    @Override
    public boolean isSelected(Object[] key) {
        int i = 0;
        while (i < this.keyValues.length) {
            if (CompareUtil.compare(this.keyValues[i], key) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

