/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.group;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.DateTimeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.group.GroupCalculator;

abstract class DateGroupCalculator
extends GroupCalculator {
    protected Date defaultStart;
    protected DateTimeUtil dateTimeUtil;

    public DateGroupCalculator(Object intervalStart, double intervalRange, ULocale locale, TimeZone timeZone) throws BirtException {
        super(intervalStart, intervalRange);
        ULocale aLocale = locale == null ? ULocale.getDefault() : locale;
        TimeZone aZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        Calendar c = Calendar.getInstance((ULocale)aLocale);
        c.setTimeZone(aZone);
        c.clear();
        c.set(1970, 0, 1);
        this.defaultStart = c.getTime();
        this.dateTimeUtil = new DateTimeUtil(aLocale, aZone);
    }

    public DateGroupCalculator(Object intervalStart, double intervalRange) throws BirtException {
        super(intervalStart, intervalRange);
        if (intervalStart != null) {
            this.intervalStart = DataTypeUtil.toDate(intervalStart);
        }
    }

    protected int getDateIntervalRange() {
        return (int)Math.round(this.intervalRange);
    }
}

