/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ods;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.ods.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.ods.IOdsWriter;
import org.eclipse.birt.report.engine.emitter.ods.OdsXmlWriter;
import org.eclipse.birt.report.engine.emitter.ods.SheetData;
import org.eclipse.birt.report.engine.emitter.ods.layout.OdsContext;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;

public class OdsWriter
implements IOdsWriter {
    private OdsXmlWriter writer;
    private OdsXmlWriter tempWriter;
    private final OdsContext context;
    private final OutputStream out;
    private final boolean isRTLSheet;
    private String tempFilePath;
    private int sheetIndex = 1;

    public OdsWriter(OutputStream out, OdsContext context, boolean isRtlSheet) {
        this.out = out;
        this.context = context;
        this.isRTLSheet = isRtlSheet;
    }

    @Override
    public void end() throws IOException {
        File file;
        this.writer.end();
        if (this.tempFilePath != null && (file = new File(this.tempFilePath)).exists() && file.isFile()) {
            file.delete();
        }
    }

    @Override
    public void endRow() {
        this.writer.endRow();
    }

    @Override
    public void outputData(SheetData data, StyleEntry style, int column, int colSpan) throws IOException {
        this.writer.outputData(data, style, column, colSpan);
    }

    @Override
    public void start(IReportContent report, HashMap<String, BookmarkDef> bookmarkList) throws IOException {
        this.writer = new OdsXmlWriter(this.out, this.context, this.isRTLSheet);
        this.writer.setSheetIndex(this.sheetIndex);
        this.writer.start(report, bookmarkList);
        this.copyOutputData();
    }

    private void copyOutputData() throws IOException {
        if (this.tempWriter != null) {
            this.tempWriter.close();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(this.tempFilePath)));
                String line = reader.readLine();
                XMLWriter xmlWriter = this.writer.getWriter();
                while (line != null) {
                    xmlWriter.literal("\n");
                    xmlWriter.literal(line);
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                    Object var1_1 = null;
                }
            }
        }
    }

    @Override
    public void startRow(StyleEntry rowStyle) {
        this.writer.startRow(rowStyle);
    }

    @Override
    public void startSheet(String name) throws IOException {
        if (this.writer == null) {
            this.initializeWriterAsTempWriter();
        }
        this.writer.startSheet(name);
        ++this.sheetIndex;
    }

    @Override
    public void startSheet(StyleEntry tableStyle, StyleEntry[] colStyles, String name) throws IOException {
        if (this.writer == null) {
            this.initializeWriterAsTempWriter();
        }
        this.writer.startSheet(tableStyle, colStyles, name);
        ++this.sheetIndex;
    }

    private void initializeWriterAsTempWriter() throws FileNotFoundException {
        this.tempFilePath = this.context.getTempFileDir() + "_BIRTEMITTER_ODS_TEMP_FILE" + Thread.currentThread().getId();
        FileOutputStream out = new FileOutputStream(this.tempFilePath);
        this.writer = this.tempWriter = new OdsXmlWriter((OutputStream)out, this.context, this.isRTLSheet);
    }

    @Override
    public void endSheet() {
        this.writer.endSheet();
    }

    @Override
    public void startRow() {
        this.writer.startRow();
    }

    @Override
    public void outputData(int col, int row, int type, Object value) {
        this.writer.outputData(col, row, type, value);
    }

    @Override
    public String defineName(String cells) {
        return this.writer.defineName(cells);
    }
}

