/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.pdf.BookmarkInfo;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPage;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PDFRender
extends PageDeviceRender {
    protected OutputStream output = null;
    protected PDFPage currentPage = null;
    protected boolean isTotalPage = false;
    protected PDFPageDevice currentPageDevice = null;
    protected HashSet<String> bookmarks = new HashSet();

    public PDFRender(IEmitterServices services) throws EngineException {
        this.initialize(services);
    }

    @Override
    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) throws Exception {
        this.currentPageDevice = new PDFPageDevice(this.output, title, author, subject, description, context, report);
        return this.currentPageDevice;
    }

    @Override
    public String getOutputFormat() {
        return "pdf";
    }

    @Override
    protected void newPage(IContainerArea page) {
        super.newPage(page);
        this.currentPage = (PDFPage)this.pageGraphic;
    }

    @Override
    public void visitImage(IImageArea imageArea) {
        int imageX = this.currentX + this.getX(imageArea);
        int imageY = this.currentY + this.getY(imageArea);
        IHyperlinkAction hlAction = imageArea.getAction();
        if (hlAction != null) {
            this.currentPageDevice.openTag("Link", imageArea);
        }
        super.visitImage(imageArea);
        this.createBookmark(imageArea, imageX, imageY);
        if (hlAction != null) {
            this.createHyperlink(imageArea, imageX, imageY);
            this.currentPageDevice.closeTag("Link", imageArea);
        }
    }

    @Override
    public void visitText(ITextArea textArea) {
        IHyperlinkAction hlAction = textArea.getAction();
        if (hlAction != null) {
            this.currentPageDevice.openTag("Link", textArea);
        }
        super.visitText(textArea);
        int x = this.currentX + this.getX(textArea);
        int y = this.currentY + this.getY(textArea);
        this.createBookmark(textArea, x, y);
        if (hlAction != null) {
            this.createHyperlink(textArea, x, y);
            this.currentPageDevice.closeTag("Link", textArea);
        }
    }

    @Override
    public void visitAutoText(ITemplateArea templateArea) {
        super.visitAutoText(templateArea);
        int x = this.currentX + this.getX(templateArea);
        int y = this.currentY + this.getY(templateArea);
        this.createTotalPageTemplate(x, y, this.getWidth(templateArea), this.getHeight(templateArea), this.scale);
    }

    @Override
    public void setTotalPage(ITextArea totalPage) {
        super.setTotalPage(totalPage);
        this.isTotalPage = true;
        HashMap<Float, PdfTemplate> map = ((PDFPageDevice)this.pageDevice).getTemplateMap();
        if (!map.isEmpty()) {
            float scaleCache = this.scale;
            for (Map.Entry<Float, PdfTemplate> e : map.entrySet()) {
                Float s = e.getKey();
                PdfTemplate template = e.getValue();
                if (template == null) continue;
                this.scale = s.floatValue();
                this.drawText(totalPage);
            }
            this.scale = scaleCache;
        }
        this.isTotalPage = false;
    }

    @Override
    public void end(IReportContent rc) {
        this.createTOC();
        super.end(rc);
    }

    @Override
    protected void drawContainer(IContainerArea container) {
        IHyperlinkAction hlAction = container.getAction();
        if (container instanceof InlineTextArea) {
            hlAction = null;
        }
        if (hlAction != null) {
            this.currentPageDevice.openTag("Link", container);
        }
        super.drawContainer(container);
        int x = this.currentX + this.getX(container);
        int y = this.currentY + this.getY(container);
        this.createBookmark(container, x, y);
        if (hlAction != null) {
            this.createHyperlink(container, x, y);
            this.currentPageDevice.closeTag("Link", container);
        }
    }

    private void initialize(IEmitterServices services) throws EngineException {
        this.services = services;
        this.reportRunnable = services.getReportRunnable();
        if (this.reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)this.reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.output = EmitterUtil.getOuputStream(services, "report.pdf");
    }

    @Override
    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textInfo) {
        if (this.isTotalPage) {
            this.currentPage.drawTotalPage(text.getText(), x, y, width, height, textInfo, this.scale);
        } else {
            this.currentPage.drawText(text.getText(), x, y, width, height, textInfo);
        }
    }

    private PdfAnnotation createHyperlink(IArea area, int x, int y) {
        PdfAnnotation annotation = null;
        IHyperlinkAction hlAction = area.getAction();
        if (hlAction != null) {
            try {
                String systemId = this.reportRunnable == null ? null : this.reportRunnable.getReportName();
                int width = this.getWidth(area);
                int height = this.getHeight(area);
                String bookmark = hlAction.getBookmark();
                String targetWindow = hlAction.getTargetWindow();
                int type = hlAction.getType();
                Action act = new Action(systemId, hlAction);
                String link = null;
                IHTMLActionHandler actionHandler = null;
                Object ac = this.services.getOption("actionHandler");
                if (ac instanceof IHTMLActionHandler) {
                    actionHandler = (IHTMLActionHandler)ac;
                }
                link = actionHandler != null ? actionHandler.getURL((IAction)act, this.context) : hlAction.getHyperlink();
                switch (type) {
                    case 2: {
                        annotation = this.currentPage.createHyperlink(link, bookmark, targetWindow, type, x, y, width, height);
                        break;
                    }
                    case 1: {
                        annotation = this.currentPage.createHyperlink(link, (String)null, targetWindow, type, x, y, width, height);
                        break;
                    }
                    case 3: {
                        annotation = this.currentPage.createHyperlink(link, (String)null, targetWindow, type, x, y, width, height);
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            if (this.currentPageDevice.isTagged()) {
                PdfArray children;
                PdfObject childObject = this.currentPageDevice.structureCurrentNode.get(PdfName.K);
                if (childObject == null) {
                    children = new PdfArray();
                    this.currentPageDevice.structureCurrentNode.put(PdfName.K, (PdfObject)children);
                } else {
                    children = new PdfArray();
                    children.add(childObject);
                    this.currentPageDevice.structureCurrentNode.put(PdfName.K, (PdfObject)children);
                }
                PdfDictionary objr = new PdfDictionary(PdfName.OBJR);
                PdfIndirectReference annotationRef = annotation.getIndirectReference();
                objr.put(PdfName.OBJ, (PdfObject)annotationRef);
                objr.put(PdfName.PG, (PdfObject)this.currentPageDevice.writer.getCurrentPage());
                children.add((PdfObject)objr);
                String tooltip = hlAction.getTooltip();
                if (tooltip != null) {
                    annotation.put(PdfName.CONTENTS, (PdfObject)new PdfString(tooltip));
                }
                PdfIndirectReference linkref = this.currentPageDevice.structureCurrentNode.getReference();
                int key = this.currentPageDevice.structureRoot.addExistingObject(linkref);
                annotation.put(PdfName.STRUCTPARENT, (PdfObject)new PdfNumber(key));
                if (this.currentPageDevice.isPdfAFormat()) {
                    annotation.put(PdfName.F, (PdfObject)new PdfNumber(4));
                }
            }
        }
        return annotation;
    }

    protected void createBookmark(IArea area, int x, int y) {
        String bookmark = area.getBookmark();
        if (bookmark != null) {
            int height = this.getHeight(area);
            int width = this.getWidth(area);
            this.currentPage.createBookmark(bookmark, x, y, width, height);
            this.bookmarks.add(bookmark);
            Map appContext = this.context.getAppContext();
            HashMap<String, BookmarkInfo> bookmarksInContext = (HashMap<String, BookmarkInfo>)appContext.get("Bookmarks");
            if (bookmarksInContext == null) {
                bookmarksInContext = new HashMap<String, BookmarkInfo>();
                appContext.put("Bookmarks", bookmarksInContext);
            }
            int pageNumber = this.currentPageDevice.writer.getCurrentPageNumber();
            BookmarkInfo bm = new BookmarkInfo(bookmark, pageNumber, x, y, width, height);
            bookmarksInContext.put(bookmark, bm);
        }
    }

    @Override
    protected void visitChildren(IContainerArea container) {
        String tagType = null;
        if (this.currentPageDevice.isTagged() && container.getChildrenCount() > 0 && (tagType = container.getTagType()) != null) {
            this.currentPageDevice.openTag(tagType, container);
        }
        super.visitChildren(container);
        if (tagType != null) {
            this.currentPageDevice.closeTag(tagType, container);
        }
    }

    private void createTOC() {
        this.currentPageDevice.createTOC(this.bookmarks);
    }

    private void createTotalPageTemplate(int x, int y, int width, int height, float scale) {
        this.currentPage.createTotalPageTemplate(x, y, width, height, scale);
    }

    @Override
    public void drawTableBorder(TableArea table) {
        boolean tagged = this.currentPageDevice.isTagged();
        if (tagged) {
            PdfDictionary properties = new PdfDictionary();
            properties.put(new PdfName("Type"), (PdfObject)new PdfName("Background"));
            this.currentPage.beginArtifact(properties);
        }
        super.drawTableBorder(table);
        if (tagged) {
            this.currentPage.endArtifact();
        }
    }
}

