/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.content.LineStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockContainerLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFCellLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFImageLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFInlineContainerLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLineAreaLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFListGroupLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFListLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFRowLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableBandLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableGroupLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTemplateLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTextBlockContainerLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTextInlineBlockLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTextLM;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class PDFLayoutManagerFactory {
    private ContentVisitor visitor = new ContentVisitor();
    PDFAbstractLM layoutManager = null;
    PDFStackingLM parent = null;
    private PDFLayoutEngineContext context = null;
    protected IReportItemExecutor executor;

    public PDFLayoutManagerFactory(PDFLayoutEngineContext context) {
        this.context = context;
    }

    public PDFAbstractLM createLayoutManager(PDFStackingLM parent, IContent content, IReportItemExecutor executor) throws BirtException {
        this.parent = parent;
        this.executor = executor;
        if (executor instanceof LineStackingExecutor) {
            return new PDFLineAreaLM(this.context, parent, executor);
        }
        if (content != null) {
            return (PDFAbstractLM)content.accept(this.visitor, null);
        }
        assert (false);
        return null;
    }

    private class ContentVisitor
    implements IContentVisitor {
        private ContentVisitor() {
        }

        @Override
        public Object visit(IContent content, Object value) {
            return this.visitContent(content, value);
        }

        @Override
        public Object visitContent(IContent content, Object value) {
            boolean isInline = PropertyUtil.isInlineElement(content);
            if (isInline) {
                return new PDFTextInlineBlockLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, content, PDFLayoutManagerFactory.this.executor);
            }
            return new PDFBlockContainerLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, content, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitPage(IPageContent page, Object value) {
            assert (false);
            return null;
        }

        @Override
        public Object visitContainer(IContainerContent container, Object value) {
            boolean isInline = PropertyUtil.isInlineElement(container);
            if (isInline) {
                return new PDFInlineContainerLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, container, PDFLayoutManagerFactory.this.executor);
            }
            return new PDFBlockContainerLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, container, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitTable(ITableContent table, Object value) {
            return new PDFTableLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, table, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitTableBand(ITableBandContent tableBand, Object value) throws BirtException {
            return new PDFTableBandLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, tableBand, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitRow(IRowContent row, Object value) {
            return new PDFRowLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, row, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitCell(ICellContent cell, Object value) {
            return new PDFCellLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, cell, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitText(ITextContent text, Object value) {
            return this.handleText(text);
        }

        @Override
        public Object visitLabel(ILabelContent label, Object value) {
            return this.handleText(label);
        }

        @Override
        public Object visitData(IDataContent data, Object value) {
            return this.handleText(data);
        }

        @Override
        public Object visitImage(IImageContent image, Object value) {
            return new PDFImageLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, image, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitForeign(IForeignContent foreign, Object value) throws BirtException {
            if ("text/html".equals(foreign.getRawType())) {
                HTML2Content.html2Content(foreign);
                PDFLayoutManagerFactory.this.executor = new DOMReportItemExecutor(foreign);
                PDFLayoutManagerFactory.this.executor.execute();
                boolean isInline = PropertyUtil.isInlineElement(foreign);
                if (isInline) {
                    return new PDFInlineContainerLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, foreign, PDFLayoutManagerFactory.this.executor);
                }
                return new PDFBlockContainerLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, foreign, PDFLayoutManagerFactory.this.executor);
            }
            LabelContent label = (LabelContent)foreign.getReportContent().createLabelContent();
            return this.handleText(label);
        }

        @Override
        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            if (1 == autoText.getType()) {
                if (PDFLayoutManagerFactory.this.parent instanceof PDFLineAreaLM) {
                    String originalPageNumber = autoText.getText();
                    DataFormatValue format = autoText.getComputedStyle().getDataFormat();
                    NumberFormatter nf = null;
                    if (format == null) {
                        nf = new NumberFormatter();
                    } else {
                        String pattern = format.getNumberPattern();
                        String locale = format.getNumberLocale();
                        nf = locale == null ? new NumberFormatter(pattern) : new NumberFormatter(pattern, new ULocale(locale));
                    }
                    try {
                        autoText.setText(nf.format(Integer.parseInt(originalPageNumber)));
                    }
                    catch (NumberFormatException nfe) {
                        autoText.setText(originalPageNumber);
                    }
                }
                return this.handleText(autoText);
            }
            return new PDFTemplateLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, autoText, PDFLayoutManagerFactory.this.executor);
        }

        private Object handleText(ITextContent content) {
            boolean isInline = PDFLayoutManagerFactory.this.parent instanceof ILineStackingLayoutManager;
            if (isInline) {
                return new PDFTextLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, content, PDFLayoutManagerFactory.this.executor);
            }
            String text = content.getText();
            if (text == null || "".equals(text)) {
                content.setText(" ");
            }
            return new PDFTextBlockContainerLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, content, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitList(IListContent list, Object value) {
            return new PDFListLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, list, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitListBand(IListBandContent listBand, Object value) {
            assert (false);
            return null;
        }

        @Override
        public Object visitListGroup(IListGroupContent group, Object value) {
            return new PDFListGroupLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, group, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitTableGroup(ITableGroupContent group, Object value) {
            return new PDFTableGroupLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, group, PDFLayoutManagerFactory.this.executor);
        }

        @Override
        public Object visitGroup(IGroupContent group, Object value) {
            return new PDFListGroupLM(PDFLayoutManagerFactory.this.context, PDFLayoutManagerFactory.this.parent, group, PDFLayoutManagerFactory.this.executor);
        }
    }
}

