/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.pkg;

import java.io.IOException;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.odf.pkg.Package;
import org.eclipse.birt.report.engine.odf.pkg.PackageEntry;

public class ImageEntry
extends PackageEntry {
    private IImageContent imageContent;
    private Image imageInfo;
    private String originalUri;
    private String imageExtension;
    private int imageSource;

    ImageEntry(Package pkg, String uri, String contentType, String originalUri, String extension) {
        super(pkg, uri, contentType, true);
        this.imageContent = null;
        this.imageInfo = null;
        this.originalUri = originalUri;
        this.imageExtension = extension;
        this.imageSource = 3;
    }

    ImageEntry(Package pkg, String uri, String contentType, IImageContent imageContent) {
        super(pkg, uri, contentType, true);
        this.imageContent = imageContent;
        this.imageInfo = null;
        this.originalUri = imageContent.getURI();
        this.imageExtension = imageContent.getExtension();
        this.imageSource = imageContent.getImageSource();
    }

    public Image getImage() throws IOException {
        if (this.imageInfo == null) {
            this.imageInfo = EmitterUtil.parseImage(this.imageContent, this.imageSource, this.originalUri, this.contentType, this.imageExtension);
        }
        return this.imageInfo;
    }
}

