/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractRealTableHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableContainer;
import uk.co.spudsoft.birt.emitters.excel.handlers.NestedTableRowHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.TopLevelListHandler;

public class NestedTableHandler
extends AbstractRealTableHandler {
    boolean inserted = false;
    private Coordinate topLeft;
    private Coordinate bottomRight;
    private int parentRowSpan;

    public String toString() {
        return "NestedTableHandler [topLeft=" + String.valueOf(this.topLeft) + ", bottomRight=" + String.valueOf(this.bottomRight) + ", parentRowSpan=" + this.parentRowSpan + "]";
    }

    public NestedTableHandler(Logger log, IHandler parent, ITableContent table, int parentRowSpan) {
        super(log, parent, table);
        this.parentRowSpan = parentRowSpan;
    }

    public void setInserted(boolean inserted) {
        this.inserted = inserted;
    }

    public boolean includesRow(int rowNum) {
        return this.topLeft.getRow() <= rowNum && this.bottomRight.getRow() >= rowNum;
    }

    public int extendParentsRowBy(int rowNum) {
        if (rowNum == this.topLeft.getRow() + this.parentRowSpan - 1 && this.bottomRight.getRow() - this.topLeft.getRow() >= this.parentRowSpan - 1) {
            int extension = 2 + this.bottomRight.getRow() - this.topLeft.getRow() - this.parentRowSpan;
            this.log.debug("Nested table ", this, " extends row ", rowNum, " by ", extension);
            return extension;
        }
        return 1;
    }

    @Override
    public void startTable(HandlerState state, ITableContent table) throws BirtException {
        String password;
        String name;
        --state.colNum;
        this.topLeft = new Coordinate(state.rowNum, state.colNum);
        this.log.debug("startTable called with topLeft = [", this.topLeft.getRow(), ", ", this.topLeft.getCol(), "]");
        super.startTable(state, table);
        if ((state.sheetName == null || state.sheetName.isEmpty()) && (name = state.correctSheetName(table.getName())) != null && !name.isEmpty()) {
            state.sheetName = name;
        }
        if ((state.sheetPassword == null || state.sheetPassword.isEmpty()) && (password = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), table, "ExcelEmitter.SheetProtectPassword", null)) != null && !password.isEmpty()) {
            state.sheetPassword = password;
        }
    }

    @Override
    public void startRow(HandlerState state, IRowContent row) throws BirtException {
        this.log.debug("startRow called with topLeft = [", this.topLeft.getRow(), ", ", this.topLeft.getCol(), "]");
        NestedTableRowHandler rowHandler = new NestedTableRowHandler(this.log, this, row, this.topLeft.getCol());
        state.setHandler(rowHandler);
        state.getHandler().startRow(state, row);
    }

    @Override
    public void endTable(HandlerState state, ITableContent table) throws BirtException {
        this.bottomRight = new Coordinate(state.rowNum - 1, state.colNum);
        super.endTable(state, table);
        if (!(this.parent instanceof TopLevelListHandler)) {
            this.log.debug("Decrementing rowNum from ", state.rowNum);
            --state.rowNum;
            --state.colNum;
        }
        state.rowNum = this.topLeft.getRow();
        NestedTableContainer parentTableHandler = this.getAncestor(NestedTableContainer.class);
        parentTableHandler.addNestedTable(this);
        if (this.bottomRight.getRow() < this.topLeft.getRow() + this.parentRowSpan - 1) {
            state.getSmu().extendRows(state, this.topLeft.getRow(), this.topLeft.getCol(), this.topLeft.getRow() + this.parentRowSpan, this.bottomRight.getCol());
        }
        state.setHandler(this.parent);
    }
}

