/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.executor.ComparatorUtil;

public class OSDataSourceDesignComparator {
    public static boolean isEqualOSDataSourceDesign(IBaseDataSourceDesign dataSourceDesign, IBaseDataSourceDesign dataSourceDesign2) {
        if (dataSourceDesign instanceof IOdaDataSourceDesign && dataSourceDesign2 instanceof IOdaDataSourceDesign) {
            IOdaDataSourceDesign dataSource = (IOdaDataSourceDesign)dataSourceDesign;
            IOdaDataSourceDesign dataSource2 = (IOdaDataSourceDesign)dataSourceDesign2;
            return ComparatorUtil.isEqualString(dataSource.getExtensionID(), dataSource2.getExtensionID()) && ComparatorUtil.isEqualProps(dataSource.getPublicProperties(), dataSource2.getPublicProperties()) && ComparatorUtil.isEqualProps(dataSource.getPrivateProperties(), dataSource2.getPrivateProperties());
        }
        if (dataSourceDesign instanceof IScriptDataSourceDesign && dataSourceDesign2 instanceof IScriptDataSourceDesign) {
            IScriptDataSourceDesign dataSource = (IScriptDataSourceDesign)dataSourceDesign;
            IScriptDataSourceDesign dataSource2 = (IScriptDataSourceDesign)dataSourceDesign2;
            return ComparatorUtil.isEqualString(dataSource.getOpenScript(), dataSource2.getOpenScript()) && ComparatorUtil.isEqualString(dataSource.getCloseScript(), dataSource2.getCloseScript());
        }
        return false;
    }

    public static boolean isEqualBaseDataSourceDesign(IBaseDataSourceDesign dataSourceDesign, IBaseDataSourceDesign dataSourceDesign2) {
        if (dataSourceDesign == dataSourceDesign2) {
            return true;
        }
        if (dataSourceDesign == null || dataSourceDesign2 == null || !ComparatorUtil.isEqualString(dataSourceDesign.getName(), dataSourceDesign2.getName())) {
            return false;
        }
        return dataSourceDesign.getBeforeOpenScript() == null && dataSourceDesign.getAfterOpenScript() == null && dataSourceDesign.getBeforeCloseScript() == null && dataSourceDesign.getAfterCloseScript() == null;
    }
}

