/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.ICubeQueryExcutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.SecuredCube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRowComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.CubeDimensionReader;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.DataSetFromOriginalCube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggrMeasureFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.SimpleLevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IAggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.ICubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.JSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.sort.IJSSortHelper;

public class CubeQueryExecutorHelper
implements ICubeQueryExcutorHelper {
    protected Cube cube;
    protected List levelFilters = null;
    protected List simpleLevelFilters = null;
    protected List measureFilters = null;
    private Map dimJSFilterMap = null;
    private List rowSort = null;
    private List columnSort = null;
    private List pageSort = null;
    protected boolean isBreakHierarchy = true;
    protected IComputedMeasureHelper computedMeasureHelper = null;
    private List aggrFilterHelpers;
    private List aggrMeasureFilters;
    protected List cubePosFilters;
    private static Logger logger = Logger.getLogger(CubeQueryExecutorHelper.class.getName());
    public int maxDataObjectRows = -1;
    public long memoryCacheSize = 0L;
    private IBindingValueFetcher fetcher;
    private CubeQueryExecutor cubeQueryExecutor;
    private Map appContext;

    public CubeQueryExecutorHelper(ICube cube) throws DataException {
        this(cube, null, null);
    }

    public CubeQueryExecutorHelper(ICube cube, IComputedMeasureHelper computedMeasureHelper, IBindingValueFetcher fetcher) throws DataException {
        Object[] params = new Object[]{cube, computedMeasureHelper};
        logger.entering(CubeQueryExecutorHelper.class.getName(), "CubeQueryExecutorHelper", params);
        this.cube = (Cube)cube;
        this.fetcher = fetcher;
        this.computedMeasureHelper = computedMeasureHelper;
        if (this.computedMeasureHelper != null) {
            this.validateComputedMeasureNames();
        }
        this.simpleLevelFilters = new ArrayList();
        this.levelFilters = new ArrayList();
        this.measureFilters = new ArrayList();
        this.aggrFilterHelpers = new ArrayList();
        this.aggrMeasureFilters = new ArrayList();
        this.dimJSFilterMap = new HashMap();
        this.rowSort = new ArrayList();
        this.columnSort = new ArrayList();
        this.pageSort = new ArrayList();
        logger.exiting(CubeQueryExecutorHelper.class.getName(), "CubeQueryExecutorHelper");
    }

    public IDiskArray getLevelMembers(DimLevel level) {
        return null;
    }

    public static ICube loadCube(String cubeName, IDocumentManager documentManager, DataEngineSession session) throws IOException, DataException {
        if (documentManager == null) {
            throw new DataException("data.olap.FailLoadCube", cubeName);
        }
        final Cube cube = new Cube(cubeName, documentManager);
        cube.load(session.getStopSign());
        session.getEngine().addShutdownListener(new IShutdownListener(){

            @Override
            public void dataEngineShutdown() {
                try {
                    cube.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return cube;
    }

    public static ICube loadCube(String cubeName, IDocumentManager documentManager, StopSign stopSign) throws IOException, DataException {
        if (documentManager == null) {
            throw new DataException("data.olap.FailLoadCube", cubeName);
        }
        Cube cube = new Cube(cubeName, documentManager);
        cube.load(stopSign);
        return cube;
    }

    public static ICube loadCube(String cubeName, IDocumentManager documentManager, StopSign stopSign, Map<String, Set<String>> notAccessibleDimLvls) throws IOException, DataException {
        if (documentManager == null) {
            throw new DataException("data.olap.FailLoadCube", cubeName);
        }
        SecuredCube cube = new SecuredCube(cubeName, documentManager, notAccessibleDimLvls);
        cube.load(stopSign);
        return cube;
    }

    public static void saveAggregationResultSet(IDocArchiveWriter writer, String name, IAggregationResultSet[] resultSets) throws IOException {
        AggregationResultSetSaveUtil.save(name, resultSets, writer);
    }

    public static void saveAggregationResultSet(String pathName, String name, IAggregationResultSet[] resultSets) throws IOException {
        FileArchiveWriter writer = new FileArchiveWriter(CubeQueryExecutorHelper.getTmpFileName(pathName, name));
        AggregationResultSetSaveUtil.save(name, resultSets, writer);
        writer.flush();
        writer.finish();
    }

    public static IAggregationResultSet[] loadAggregationResultSet(IDocArchiveReader reader, String name) throws IOException {
        return AggregationResultSetSaveUtil.load(name, reader, VersionManager.getLatestVersion(), 0x500000L);
    }

    public static IAggregationResultSet[] loadAggregationResultSet(String pathName, String name) throws IOException {
        FileArchiveReader reader = new FileArchiveReader(CubeQueryExecutorHelper.getTmpFileName(pathName, name));
        IAggregationResultSet[] result = AggregationResultSetSaveUtil.load(name, reader, VersionManager.getLatestVersion(), 0x500000L);
        reader.close();
        return result;
    }

    private static String getTmpFileName(String pathName, String name) {
        return pathName + File.separator + "cubequeryresult" + name;
    }

    public void addRowSort(ITargetSort sort) {
        this.rowSort.add(sort);
    }

    public List getRowSort() {
        return this.rowSort;
    }

    public List getColumnSort() {
        return this.columnSort;
    }

    public void addColumnSort(ITargetSort sort) {
        this.columnSort.add(sort);
    }

    public List getPageSort() {
        return this.pageSort;
    }

    public void addPageSort(ITargetSort sort) {
        this.pageSort.add(sort);
    }

    @Override
    public void addFilter(LevelFilter levelFilter) {
        this.levelFilters.add(levelFilter);
    }

    @Override
    public void addSimpleLevelFilter(SimpleLevelFilter simpleLevelFilter) {
        this.simpleLevelFilters.add(simpleLevelFilter);
    }

    public void addSimpleLevelFilter(List<SimpleLevelFilter> simpleLevelFilter) {
        this.simpleLevelFilters.addAll(simpleLevelFilter);
    }

    @Override
    public void clear() {
        this.levelFilters.clear();
        this.aggrFilterHelpers.clear();
        this.aggrMeasureFilters.clear();
        this.dimJSFilterMap.clear();
        this.rowSort.clear();
        this.columnSort.clear();
    }

    @Override
    public void close() {
        this.levelFilters = null;
        this.aggrFilterHelpers = null;
        this.aggrMeasureFilters = null;
        this.dimJSFilterMap = null;
        this.rowSort = null;
        this.columnSort = null;
    }

    @Override
    public IAggregationResultSet[] execute(AggregationDefinition[] aggregations, StopSign stopSign) throws IOException, BirtException {
        if (!this.isDimensionTableQuery(aggregations)) {
            return this.executeFactTableQuery(aggregations, stopSign);
        }
        IAggregationResultSet[] resultSet = new IAggregationResultSet[]{this.executeDimensionTableQuery(aggregations[0], stopSign)};
        return resultSet;
    }

    private boolean isDimensionTableQuery(AggregationDefinition[] aggregations) {
        if (aggregations.length > 1 || aggregations[0].getAggregationFunctions() != null) {
            return false;
        }
        DimLevel[] levels = aggregations[0].getLevels();
        if (levels == null || levels.length == 0) {
            return false;
        }
        int i = 0;
        while (i < levels.length) {
            int j = 0;
            while (j < levels.length) {
                if (!levels[i].getDimensionName().equals(levels[j].getDimensionName())) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        if (this.measureFilters.size() > 0) {
            return false;
        }
        if (this.aggrFilterHelpers.size() > 0) {
            return false;
        }
        if (this.dimJSFilterMap.size() > 1 || this.dimJSFilterMap.size() == 1 && this.dimJSFilterMap.get(levels[0].getDimensionName()) == null) {
            return false;
        }
        i = 0;
        while (i < this.simpleLevelFilters.size()) {
            if (!levels[0].getDimensionName().equals(((SimpleLevelFilter)this.simpleLevelFilters.get(i)).getDimensionName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IAggregationResultSet[] executeFactTableQuery(AggregationDefinition[] aggregations, StopSign stopSign) throws IOException, BirtException {
        IAggregationResultSet[] resultSet = this.onePassExecute(aggregations, stopSign);
        resultSet = this.processDimensionFiltersInAggrBindingFilter(resultSet);
        this.applyAggrFilters(aggregations, resultSet, stopSign);
        this.applyAggrSort(resultSet);
        return resultSet;
    }

    public void setCubeQueryExecutor(CubeQueryExecutor executor) {
        this.cubeQueryExecutor = executor;
    }

    private IAggregationResultSet[] processDimensionFiltersInAggrBindingFilter(IAggregationResultSet[] rs) throws IOException, BirtException {
        int i = 0;
        while (i < rs.length) {
            AggregationFunctionDefinition[] functions = rs[i].getAggregationDefinition().getAggregationFunctions();
            if (functions != null) {
                IAggregationResultSet[] subAggrRs = new IAggregationResultSet[functions.length];
                boolean applyMerge = false;
                int j = 0;
                while (j < functions.length) {
                    IBaseExpression expr;
                    Set dimLevelSet;
                    if (functions[j].getFilterEvalHelper() != null && functions[j].getFilterEvalHelper() instanceof JSFacttableFilterEvalHelper && (dimLevelSet = OlapExpressionCompiler.getReferencedDimLevel(expr = ((JSFacttableFilterEvalHelper)functions[j].getFilterEvalHelper()).getFilterExpression(), this.cubeQueryExecutor.getCubeQueryDefinition().getBindings())).size() > 0) {
                        if (OlapExpressionCompiler.getReferencedScriptObject(expr, "measure") != null || this.containsMultiDimension(dimLevelSet)) {
                            applyMerge = false;
                            break;
                        }
                        applyMerge = true;
                        CubeQueryExecutorHelper executorHelper = this.createCubeQueryExecutorHelper(this.cube, this.cubeQueryExecutor.getComputedMeasureHelper(), this.fetcher);
                        executorHelper.setBreakHierarchy(this.cubeQueryExecutor.getCubeQueryDefinition().getFilterOption() == 0);
                        CubeFilterDefinition cubeFilter = new CubeFilterDefinition(expr);
                        executorHelper.addJSFilter(BaseDimensionFilterEvalHelper.createFilterHelper(this.cubeQueryExecutor.getOuterResults(), this.cubeQueryExecutor.getScope(), this.cubeQueryExecutor.getCubeQueryDefinition(), cubeFilter, this.cubeQueryExecutor.getContext().getScriptContext()));
                        AggregationDefinition[] aggregations = new AggregationDefinition[1];
                        AggregationFunctionDefinition[] func = new AggregationFunctionDefinition[]{new AggregationFunctionDefinition("temp_" + functions[j].getName(), functions[j].getMeasureName(), functions[j].getFunctionName())};
                        if (functions[j].getTimeFunction() != null) {
                            func[0].setTimeFunction(functions[j].getTimeFunction());
                        }
                        if (functions[j].getTimeFunctionFilter() != null) {
                            func[0].setTimeFunctionFilter(functions[j].getTimeFunctionFilter());
                        }
                        aggregations[0] = new AggregationDefinition(rs[i].getAggregationDefinition().getLevels(), rs[i].getAggregationDefinition().getSortTypes(), func);
                        IAggregationResultSet[] result = executorHelper.execute(aggregations, this.cubeQueryExecutor.getSession().getStopSign());
                        subAggrRs[j] = result[0];
                    }
                    ++j;
                }
                if (applyMerge) {
                    this.mergeAggrResultsSetsResult(rs[i], subAggrRs);
                }
            }
            ++i;
        }
        return rs;
    }

    private boolean containsMultiDimension(Set dimLevelSet) {
        HashSet dimSet = new HashSet();
        for (Object dimLevel : dimLevelSet) {
            if (!(dimLevel instanceof DimLevel)) continue;
            dimSet.add(dimLevel);
        }
        return dimSet.size() > 1;
    }

    private int[] getKeyLevelIndexs(DimLevel[] keyLevels, IAggregationResultSet rs) throws DataException {
        if (keyLevels == null || keyLevels.length == 0) {
            return new int[0];
        }
        int[] keyLevelIndexes = new int[keyLevels.length];
        DimLevel[] allLevels = rs.getAllLevels();
        int i = 0;
        while (i < keyLevels.length) {
            keyLevelIndexes[i] = -1;
            int j = 0;
            while (j < allLevels.length) {
                if (keyLevels[i].equals(allLevels[j])) {
                    keyLevelIndexes[i] = j;
                }
                ++j;
            }
            if (keyLevelIndexes[i] == -1) {
                throw new DataException(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentLevel") + keyLevels[i].getLevelName());
            }
            ++i;
        }
        return keyLevelIndexes;
    }

    private void mergeAggrResultsSetsResult(IAggregationResultSet source, IAggregationResultSet[] result) throws IOException, DataException {
        IDiskArray sourceRows = ((AggregationResultSet)source).getAggregationResultRows();
        AggregationResultRowComparator comparator = new AggregationResultRowComparator(this.getKeyLevelIndexs(source.getAggregationDefinition().getLevels(), source), source.getSortType());
        int i = 0;
        while (i < source.length()) {
            IAggregationResultRow row = (IAggregationResultRow)sourceRows.get(i);
            int j = 0;
            while (j < result.length) {
                IAggregationResultSet rs = result[j];
                if (rs != null) {
                    IDiskArray subRows = ((AggregationResultSet)rs).getAggregationResultRows();
                    boolean find = false;
                    int k = 0;
                    while (k < subRows.size()) {
                        IAggregationResultRow subRow = (IAggregationResultRow)subRows.get(k);
                        if (comparator.compare(row, subRow) == 0) {
                            find = true;
                            row.getAggregationValues()[j] = subRow.getAggregationValues()[0];
                            break;
                        }
                        ++k;
                    }
                    if (!find) {
                        row.getAggregationValues()[j] = null;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private IAggregationResultSet executeDimensionTableQuery(AggregationDefinition aggregations, StopSign stopSign) throws IOException, BirtException {
        DimLevel[] levels = aggregations.getLevels();
        String dimensionName = levels[0].getDimensionName();
        IDimension[] dimensions = this.cube.getDimesions();
        Dimension sourceDimension = null;
        int i = 0;
        while (i < dimensions.length) {
            if (dimensionName.equals(dimensions[i].getName())) {
                sourceDimension = (Dimension)dimensions[i];
                break;
            }
            ++i;
        }
        IDiskArray dimensionrow = this.getFiltedDistinctDiemensionRow(sourceDimension, levels, aggregations.getSortTypes(), stopSign);
        AggregationResultSet resultSet = new AggregationResultSet(aggregations, dimensionrow, CubeQueryExecutorHelper.getKeyColumnName(aggregations), CubeQueryExecutorHelper.getAttributeColumnName(aggregations, sourceDimension));
        return resultSet;
    }

    private static String[][] getAttributeColumnName(AggregationDefinition aggregation, Dimension dimension) {
        DimLevel[] levels = aggregation.getLevels();
        String[][] result = new String[levels.length][1];
        int i = 0;
        while (i < levels.length) {
            result[i][0] = levels[i].getLevelName();
            ILevel[] dimLevels = dimension.getHierarchy().getLevels();
            int j = 0;
            while (j < dimLevels.length) {
                if (dimLevels[j].getName().equals(levels[i].getLevelName())) {
                    result[i] = dimLevels[j].getAttributeNames();
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static String[][] getKeyColumnName(AggregationDefinition aggregation) {
        DimLevel[] levels = aggregation.getLevels();
        String[][] result = new String[levels.length][1];
        int i = 0;
        while (i < levels.length) {
            result[i][0] = levels[i].getLevelName();
            ++i;
        }
        return result;
    }

    private IDiskArray getFiltedDistinctDiemensionRow(Dimension dimension, DimLevel[] levels, int[] sortType, StopSign stopSign) throws DataException, IOException {
        List jsFilters = this.getDimensionJSFilterList(dimension.getName());
        LevelFilterHelper filterHelper = new LevelFilterHelper(dimension, this.simpleLevelFilters, this.levelFilters);
        IDiskArray filtedPosition = filterHelper.getJSFilterResult(jsFilters, this.isBreakHierarchy);
        IDiskArray filtedRow = null;
        int[] levelIndex = new int[levels.length];
        int i = 0;
        while (i < levels.length) {
            levelIndex[i] = CubeQueryExecutorHelper.getLevelIndex(dimension, levels[i]);
            ++i;
        }
        if (filtedPosition != null) {
            filtedRow = dimension.getDimensionRowByPositions(filtedPosition, stopSign);
        } else {
            int levelSize = dimension.getHierarchy().getLevels().length;
            if (levels.length == 1 && levelIndex[0] < levelSize - 1 && (levelSize == 2 || levelIndex[0] < levelSize - 2 && levelSize > 2)) {
                Level targetLevel = (Level)dimension.getHierarchy().getLevels()[levelIndex[0]];
                filtedRow = dimension.getDimensionRowByPositions(targetLevel.getAllPosition(), stopSign);
            } else {
                filtedRow = dimension.getAllRows(stopSign);
            }
        }
        BufferedStructureArray result = new BufferedStructureArray(AggregationResultRow.getCreator(), Constants.LIST_BUFFER_SIZE);
        DimensionRow dimensionRow = null;
        Member[] members = null;
        boolean isAscending = true;
        if (sortType[0] == 1) {
            isAscending = false;
        }
        DiskSortedStack sortedRow = new DiskSortedStack(filtedRow.size(), isAscending, true, AggregationResultRow.getCreator());
        int i2 = 0;
        while (i2 < filtedRow.size()) {
            dimensionRow = (DimensionRow)filtedRow.get(i2);
            members = new Member[levels.length];
            int j = 0;
            while (j < members.length) {
                members[j] = dimensionRow.getMembers()[levelIndex[j]];
                ++j;
            }
            sortedRow.push(new AggregationResultRow(members, null));
            ++i2;
        }
        Object obj = sortedRow.pop();
        while (obj != null) {
            result.add((AggregationResultRow)obj);
            obj = sortedRow.pop();
        }
        return result;
    }

    private static int getLevelIndex(Dimension dimension, DimLevel level) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        if (levels == null) {
            return -1;
        }
        int i = 0;
        while (i < levels.length) {
            if (levels[i].getName().equals(level.getLevelName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void applyAggrSort(IAggregationResultSet[] resultSet) throws DataException {
        if (!this.columnSort.isEmpty()) {
            AggrSortHelper.sort(this.columnSort, resultSet, this.fetcher);
            this.closeSortHelpers(this.columnSort);
        }
        if (!this.rowSort.isEmpty()) {
            AggrSortHelper.sort(this.rowSort, resultSet, this.fetcher);
            this.closeSortHelpers(this.rowSort);
        }
    }

    private void closeSortHelpers(List sorts) {
        for (ITargetSort targetSot : sorts) {
            if (!(targetSot instanceof IJSSortHelper)) continue;
            IJSSortHelper sortHelper = (IJSSortHelper)targetSot;
            sortHelper.close();
        }
    }

    protected boolean populateAggrMeasureFilterResult(ICube cube, IAggregationResultSet[] resultSet, List aggrMeasureFilters, CubeQueryExecutor cubeQueryExecutor, IBindingValueFetcher fetcher) throws DataException, IOException {
        AggrMeasureFilterHelper filter = new AggrMeasureFilterHelper(cube, resultSet);
        filter.setQueryExecutor(cubeQueryExecutor);
        filter.setBindingValueFetcher(fetcher);
        this.cubePosFilters = filter.getCubePosFilters(aggrMeasureFilters);
        if (this.cubePosFilters == null) {
            int i = 0;
            while (i < resultSet.length) {
                resultSet[i].clear();
                ++i;
            }
            return false;
        }
        return true;
    }

    public void applyAggrFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet, StopSign stopSign) throws IOException, DataException, BirtException {
        boolean recalculate = false;
        if (!this.aggrMeasureFilters.isEmpty()) {
            recalculate = this.populateAggrMeasureFilterResult(this.cube, resultSet, this.aggrMeasureFilters, this.cubeQueryExecutor, this.fetcher);
        }
        if (!this.aggrFilterHelpers.isEmpty()) {
            AggregationFilterHelper filterHelper = new AggregationFilterHelper(this.cube, this.aggrFilterHelpers, this.fetcher);
            List newFilters = filterHelper.generateLevelFilters(aggregations, resultSet);
            if (newFilters == null) {
                int i = 0;
                while (i < resultSet.length) {
                    resultSet[i].clear();
                    recalculate = false;
                    ++i;
                }
            } else {
                this.levelFilters.addAll(newFilters);
                int i = 0;
                while (i < resultSet.length) {
                    resultSet[i].close();
                    resultSet[i] = null;
                    ++i;
                }
                recalculate = true;
            }
        }
        if (recalculate) {
            IAggregationResultSet[] temp = this.onePassExecute(aggregations, stopSign);
            System.arraycopy(temp, 0, resultSet, 0, temp.length);
        }
    }

    protected IAggregationResultSet[] onePassExecute(AggregationDefinition[] aggregations, StopSign stopSign) throws DataException, IOException, BirtException {
        boolean use11SP3CubeQuery;
        IDiskArray[] dimPosition = this.getFilterResult();
        FactTableRowIterator factTableRowIterator = this.populateFactTableIterator(stopSign, dimPosition);
        IDimensionResultIterator[] dimensionResultIterators = this.populateDimensionResultIterator(dimPosition, stopSign);
        DataSetFromOriginalCube dataSet4Aggregation = new DataSetFromOriginalCube(factTableRowIterator, dimensionResultIterators, this.computedMeasureHelper);
        long memoryCacheSize = this.memoryCacheSize;
        if (this.appContext != null && (use11SP3CubeQuery = CacheUtil.enableSP3CubeQueryChange(this.appContext))) {
            memoryCacheSize = -memoryCacheSize;
        }
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(new CubeDimensionReader(this.cube), dataSet4Aggregation, aggregations, memoryCacheSize);
        aggregationCalculatorExecutor.setMaxDataObjectRows(this.maxDataObjectRows);
        return aggregationCalculatorExecutor.execute(stopSign);
    }

    public FactTableRowIterator populateFactTableIterator(StopSign stopSign, IDiskArray[] dimPosition) throws IOException {
        int count = 0;
        int i = 0;
        while (i < dimPosition.length) {
            if (dimPosition[i] != null) {
                ++count;
            }
            ++i;
        }
        IDimension[] dimensions = this.cube.getDimesions();
        String[] validDimensionName = new String[count];
        IDiskArray[] validDimPosition = new IDiskArray[count];
        int pos = 0;
        int i2 = 0;
        while (i2 < dimPosition.length) {
            if (dimPosition[i2] != null) {
                validDimPosition[pos] = dimPosition[i2];
                validDimensionName[pos] = dimensions[i2].getName();
                ++pos;
            }
            ++i2;
        }
        FactTableRowIterator factTableRowIterator = new FactTableRowIterator(this.cube.getFactTable(), validDimensionName, validDimPosition, this.cube.getDimesions(), null, stopSign);
        if (this.cubePosFilters != null && !this.cubePosFilters.isEmpty()) {
            for (ICubePosFilter cubePosFilter : this.cubePosFilters) {
                factTableRowIterator.addCubePosFilter(cubePosFilter);
            }
        }
        int i3 = 0;
        while (i3 < this.measureFilters.size()) {
            factTableRowIterator.addMeasureFilter((IJSFacttableFilterEvalHelper)this.measureFilters.get(i3));
            ++i3;
        }
        return factTableRowIterator;
    }

    private DimensionResultIterator[] populateDimensionResultIterator(IDiskArray[] position, StopSign stopSign) throws DataException, IOException {
        IDimension[] dimensions = this.cube.getDimesions();
        DimensionResultIterator[] dimResultSet = new DimensionResultIterator[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            dimResultSet[i] = new DimensionResultIterator((Dimension)dimensions[i], position[i], stopSign);
            ++i;
        }
        return dimResultSet;
    }

    protected List getDimensionJSFilterList(String dimensionName) {
        Object value = this.dimJSFilterMap.get(dimensionName);
        if (value != null) {
            return (List)value;
        }
        ArrayList list = new ArrayList();
        this.dimJSFilterMap.put(dimensionName, list);
        return list;
    }

    public IDiskArray[] getFilterResult() throws DataException, IOException {
        IDimension[] dimensions = this.cube.getDimesions();
        IDiskArray[] dimPosition = new IDiskArray[dimensions.length];
        int i = 0;
        while (i < dimPosition.length) {
            Dimension dimension = (Dimension)dimensions[i];
            List jsFilters = this.getDimensionJSFilterList(dimension.getName());
            LevelFilterHelper filterHelper = new LevelFilterHelper(dimension, this.simpleLevelFilters, this.levelFilters);
            dimPosition[i] = filterHelper.getJSFilterResult(jsFilters, this.isBreakHierarchy);
            ++i;
        }
        return dimPosition;
    }

    public void addAggrMeasureFilter(List<IAggrMeasureFilterEvalHelper> aggrFilterHelper) {
        this.aggrMeasureFilters.addAll(aggrFilterHelper);
    }

    @Override
    public void addJSFilter(IJSFilterHelper filterEvalHelper) {
        if (!filterEvalHelper.isAggregationFilter()) {
            String dimesionName = filterEvalHelper.getDimensionName();
            List filterList = this.getDimensionJSFilterList(dimesionName);
            filterList.add(filterEvalHelper);
        } else {
            this.aggrFilterHelpers.add(filterEvalHelper);
        }
    }

    @Override
    public void addJSFilter(List filterEvalHelperList) {
        int i = 0;
        while (i < filterEvalHelperList.size()) {
            this.addJSFilter((IJSFilterHelper)filterEvalHelperList.get(i));
            ++i;
        }
    }

    @Override
    public void addMeasureFilter(List<IJSFacttableFilterEvalHelper> measureFilter) {
        this.measureFilters.addAll(measureFilter);
    }

    public void setBreakHierarchy(boolean isBreakHierarchy) {
        this.isBreakHierarchy = isBreakHierarchy;
    }

    private void validateComputedMeasureNames() throws DataException {
        HashSet<String> existNames = new HashSet<String>(Arrays.asList(this.cube.getMeasureNames()));
        MeasureInfo[] mis = this.computedMeasureHelper.getAllComputedMeasureInfos();
        int i = 0;
        while (i < mis.length) {
            String name = mis[i].getMeasureName();
            if (existNames.contains(name)) {
                throw new DataException("data.olap.duplicateMeasureName", name);
            }
            existNames.add(name);
            ++i;
        }
    }

    public void setMaxDataObjectRows(int rowSize) {
        this.maxDataObjectRows = rowSize;
    }

    public int getMaxDataObjectRows() {
        return this.maxDataObjectRows;
    }

    public void setMemoryCacheSize(long memoryCacheSize) {
        this.memoryCacheSize = memoryCacheSize;
    }

    public void setAppContext(Map appContext) {
        this.appContext = appContext;
    }

    public long getMemoryCacheSize() {
        return this.memoryCacheSize;
    }

    protected CubeQueryExecutorHelper createCubeQueryExecutorHelper(ICube cube, IComputedMeasureHelper computedMeasureHelper, IBindingValueFetcher fetcher) throws DataException {
        return new CubeQueryExecutorHelper(cube, computedMeasureHelper, fetcher);
    }
}

