/*
 * Decompiled with CFR 0.152.
 */
package ch.rfin.util;

import ch.rfin.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Pairs {
    public static <T, S> Pair<T, S> pairFrom(Map.Entry<T, S> entry) {
        return Pair.of(entry.getKey(), entry.getValue());
    }

    public static <T> Pair<T, T> pairFrom(List<T> items) {
        return Pair.of(items.get(0), items.get(1));
    }

    public static <T> List<Pair<T, T>> pairs(List<T> items) {
        int len = items.size();
        if (len == 0) {
            return Collections.emptyList();
        }
        if (len % 2 != 0) {
            throw new IllegalArgumentException(len + " is not an even number of items");
        }
        ArrayList<Pair<T, T>> result = new ArrayList<Pair<T, T>>(len / 2);
        for (int i = 1; i < len; i += 2) {
            result.add(Pair.of(items.get(i - 1), items.get(i)));
        }
        return result;
    }

    public static <K, V> List<Pair<K, V>> pairs(Map<K, V> items) {
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        return items.entrySet().stream().map(Pairs::pairFrom).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> toMap(Collection<Pair<K, V>> items) {
        if (items.isEmpty()) {
            return Collections.emptyMap();
        }
        return items.stream().collect(Collectors.toMap(Pair::get_1, Pair::get_2));
    }

    public static <T1, T2, R> Function<Pair<T1, T2>, R> function(BiFunction<T1, T2, R> f) {
        return p -> f.apply(p._1, p._2);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> biFunction(Function<Pair<T1, T2>, R> f) {
        return (a, b) -> f.apply(Pair.of(a, b));
    }

    public static <T1, T2> Predicate<Pair<T1, T2>> predicate(BiPredicate<T1, T2> f) {
        return p -> f.test(p._1, p._2);
    }

    public static <T1, T2> BiPredicate<T1, T2> biPredicate(Predicate<Pair<T1, T2>> f) {
        return (a, b) -> f.test(Pair.of(a, b));
    }

    public static <T1, T2> Consumer<Pair<T1, T2>> consumer(BiConsumer<T1, T2> f) {
        return p -> f.accept(p._1, p._2);
    }

    public static <T1, T2> BiConsumer<T1, T2> biConsumer(Consumer<Pair<T1, T2>> f) {
        return (a, b) -> f.accept(Pair.of(a, b));
    }

    public static <T, R> Function<T, Pair<T, R>> withId(Function<T, R> f) {
        return x -> Pair.of(x, f.apply(x));
    }
}

